package com.xebialabs.deployit.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class SecurityServiceLocator {

	private static final AtomicReference<PermissionService> permissionService = new AtomicReference<PermissionService>();
	private static final AtomicReference<AccessControlService> accessControlService = new AtomicReference<AccessControlService>();

	@Autowired
	public SecurityServiceLocator(PermissionService permissionService, AccessControlService accessControlService) {
		SecurityServiceLocator.accessControlService.set(accessControlService);
		SecurityServiceLocator.permissionService.set(permissionService);
	}

	public static AccessControlService getAccessControlService() {
		return SecurityServiceLocator.accessControlService.get();
	}

	public static PermissionService getPermissionService() {
		return SecurityServiceLocator.permissionService.get();
	}
}
