package com.xebialabs.deployit.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import java.io.IOException;

@Component
public class JcrUserService implements UserService {

	@Autowired
	private JcrTemplate jcrTemplate;

	@Override
    public void create(final String username, final String password) {
		jcrTemplate.execute(new JcrCallback<Object>() {
			@Override
			public Object doInJcr(Session session) throws IOException, RepositoryException {
				UserManager um = ((JackrabbitSession) session).getUserManager();

				um.createUser(username, password);
				return null;
			}
		});
	}

	@Override
    public JcrUser read(final String username) {
		return jcrTemplate.execute(new JcrCallback<JcrUser>() {
			@Override
			public JcrUser doInJcr(Session session) throws IOException, RepositoryException {
				User u = getUser(username, session);
				return new JcrUser(u.getID(), u.isAdmin());
			}
		});

	}

	@Override
    public void modifyPassword(final String username, final String newPassword) {
		jcrTemplate.execute(new JcrCallback<Object>() {
			@Override
			public Object doInJcr(Session session) throws IOException, RepositoryException {
				User u = getUser(username, session);
				u.changePassword(newPassword);
				return null;
			}
		});

	}

	@Override
    public void delete(final String username) {
		jcrTemplate.execute(new JcrCallback<Object>() {
			@Override
			public Object doInJcr(Session session) throws IOException, RepositoryException {
				User u = getUser(username, session);
				u.remove();
				return null;
			}
		});

	}

	private User getUser(final String username, Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
		UserManager um = ((JackrabbitSession) session).getUserManager();

		Authorizable authorizable = um.getAuthorizable(username);
		if (authorizable == null) {
			throw new NotFoundException("No such user: " + username);
		}

		if (authorizable.isGroup()) {
			throw new IllegalStateException("Principal " + username + " is not a user");
		}

		User u = (User) authorizable;
		return u;
	}

}
