package com.xebialabs.deployit.plugin;

import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

/**
 * A Lazy file for a Derived Artifact.
 */
public class DerivedArtifactFile {

	private static final Class proxyClass = createProxyClass();

	private static Class createProxyClass() {
		ProxyFactory proxyFactory = new ProxyFactory();
		proxyFactory.setSuperclass(LocalFile.class);
		proxyFactory.setUseCache(false);
		proxyFactory.setUseWriteReplace(false);
		return proxyFactory.createClass();
	}

	@SuppressWarnings({ "rawtypes", "deprecation" })
    public static LocalFile create(final DerivedArtifact artifact) {
		try {
			Constructor constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
			LocalFile o = (LocalFile) constructor.newInstance(LocalConnection.getLocalConnection(), null);
			((ProxyObject) o).setHandler(getMethodHandler(artifact));
			return o;
		} catch (Exception e) {
			throw new RuntimeException("Failed to create a proxy.", e);
		}
	}

	@SuppressWarnings("rawtypes")
    private static MethodHandler getMethodHandler(final DerivedArtifact artifact) {
		return new DerivedFileHandler(artifact);
	}

	@SuppressWarnings("serial")
    public static class DerivedFileHandler implements MethodHandler, Serializable {
		@SuppressWarnings("rawtypes")
        private DerivedArtifact artifact;

		@SuppressWarnings("rawtypes")
        public DerivedFileHandler(DerivedArtifact artifact) {
			this.artifact = artifact;
		}

		@Override
		public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
			if (ProxyFactory.isProxyClass(artifact.getFile().getClass())) {
				checkArgument(artifact.getSourceArtifact() != null, "%s should have a source artifact.", artifact.getId());
				checkArgument(artifact.getSourceArtifact().getFile() != null, "Source artifact %s of %s should have a file set.", artifact.getId(), artifact.getSourceArtifact().getId());
				// Swap myself out
				artifact.initFile(new PlaceholderReplacer() {
					@Override
					public void replace(Reader in, Writer out, Map<String, String> resolution) {
						new MustachePlaceholderReplacer(resolution).replace(in, out);
					}
				});
			}
			return thisMethod.invoke(artifact.getFile(), args);
		}
	}
}
