/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ReleaseInfo {
	private static final String UNKNOWN_VERSION = "0.0";
	private static final String UNKNOWN_DATE = "UNKNOWN_DATE";

	private String version;
	private String date;

	private ReleaseInfo() {
		Resource releaseInfo = new ClassPathResource("com/xebialabs/deployit/release.properties");
		try {
			InputStream in = releaseInfo.getInputStream();
			try {
				Properties p = new Properties();
				p.load(in);
				version = p.getProperty("version", UNKNOWN_VERSION);
				date = p.getProperty("timestamp", UNKNOWN_DATE);
			} finally {
				in.close();
			}
		} catch (IOException exc) {
			version = UNKNOWN_VERSION;
			date = UNKNOWN_DATE;
		}
	}
	
	public String getVersion() {
		return version;
	}

	public String getDate() {
		return date;
	}
	
	private static ReleaseInfo instance;

	public synchronized static ReleaseInfo getReleaseInfo() {
		if (instance == null) {
			instance = new ReleaseInfo();
		}
		return instance;
	}

}
