/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;
    private DeployedApplication oldApp;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDeploymentTask.class);

    public UpgradeDeploymentTask(DeltaSpecification specification, DeployedApplication oldApp, List<? extends DeploymentStep> steps, RepositoryService repositoryService, WorkDir oldWorkDir, WorkDir newWorkDir) {
        super(steps, repositoryService, oldWorkDir, newWorkDir);
        this.specification = specification;
        this.oldApp = oldApp;
        this.initFromDeployment(specification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                UpgradeDeploymentTask.this.repositoryService.checkReferentialIntegrity(UpgradeDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        DeployedApplication newDeployment = this.specification.getDeployedApplication();
        ArrayList createRoes = Lists.newArrayList();
        ArrayList updateRoes = Lists.newArrayList();
        ArrayList deleteRoeIds = Lists.newArrayList();
        for (Delta operation : this.specification.getDeltas()) {
            switch (operation.getOperation()) {
                case CREATE: {
                    createRoes.add(operation.getDeployed());
                    newDeployment.addDeployed(operation.getDeployed());
                    logger.info("The CI {} was {} in the repository", (Object)operation.getDeployed().getId(), (Object)operation.getOperation());
                    break;
                }
                case DESTROY: {
                    this.oldApp.getDeployeds().remove(operation.getPrevious());
                    updateRoes.add(this.oldApp);
                    deleteRoeIds.add(operation.getPrevious().getId());
                    logger.info("The CI {} was {} in the repository", (Object)operation.getPrevious().getId(), (Object)operation.getOperation());
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    updateRoes.add(operation.getDeployed());
                    newDeployment.addDeployed(operation.getDeployed());
                    logger.info("The CI {} was {} in the repository", (Object)operation.getDeployed().getId(), (Object)operation.getOperation());
                }
            }
        }
        updateRoes.add(newDeployment);
        ChangeSet changeset = new ChangeSet();
        changeset.setDeleteCiIds(deleteRoeIds);
        changeset.setCreateCis(createRoes);
        changeset.setUpdateCis(updateRoes);
        return changeset;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                UpgradeDeploymentTask.this.repositoryService.execute(UpgradeDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.UPGRADE;
    }
}

