/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.permission.DiscoveryHandler;
import com.xebialabs.deployit.security.permission.EditRepositoryHandler;
import com.xebialabs.deployit.security.permission.GlobalPermissionHandler;
import com.xebialabs.deployit.security.permission.InitialDeploymentHandler;
import com.xebialabs.deployit.security.permission.InitialImportHandler;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.ReadHandler;
import com.xebialabs.deployit.security.permission.UndeploymentHandler;
import com.xebialabs.deployit.security.permission.UpgradeDeploymentHandler;
import com.xebialabs.deployit.security.permission.UpgradeImportHandler;

public enum Permission {
    LOGIN("login"),
    READ("read", new ReadHandler()),
    IMPORT_INITIAL("import#initial", new InitialImportHandler()),
    IMPORT_UPGRADE("import#upgrade", new UpgradeImportHandler()),
    DEPLOY_INITIAL("deploy#initial", new InitialDeploymentHandler()),
    DEPLOY_UPGRADE("deploy#upgrade", new UpgradeDeploymentHandler()),
    DISCOVERY("discovery", new DiscoveryHandler()),
    UNDEPLOY("deploy#undeploy", new UndeploymentHandler()),
    EDIT_REPO("repo#edit", new EditRepositoryHandler()),
    TASK_MOVESTEP("task#move_step"),
    TASK_SKIPSTEP("task#skip_step"),
    CONTROLTASK_EXECUTE("controltask#execute");

    private PermissionHandler permissionHandler;
    private String permissionName;

    private Permission(String permissionName) {
        this.permissionName = permissionName;
        this.permissionHandler = new GlobalPermissionHandler(){

            @Override
            Permission getPermission() {
                return Permission.this;
            }
        };
    }

    private Permission(String permissionName, PermissionHandler permissionHandler) {
        this.permissionName = permissionName;
        this.permissionHandler = permissionHandler;
    }

    public static Permission find(String permissionName) {
        for (Permission permission : Permission.values()) {
            if (!permission.permissionName.equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public String getPermissionName() {
        return this.permissionName;
    }
}

