/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;

public class UndeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;
    private DeployedApplication existingDeployment;

    public UndeploymentTask(DeltaSpecification specification, DeployedApplication existingDeployment, List<? extends DeploymentStep> steps, RepositoryService repositoryService, WorkDir workDir) {
        super(steps, repositoryService, workDir);
        this.specification = specification;
        this.existingDeployment = existingDeployment;
        this.initFromDeployment(existingDeployment);
    }

    @Override
    public void performPreFlightChecks() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                ChangeSet changeset = UndeploymentTask.this.determineRepositoryChanges();
                UndeploymentTask.this.repositoryService.checkReferentialIntegrity(changeset);
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        ArrayList roesToDelete = Lists.newArrayList();
        roesToDelete.add(this.existingDeployment.getId());
        for (Delta delta : this.specification.getDeltas()) {
            roesToDelete.add(delta.getPrevious().getId());
        }
        ChangeSet batchUpdate = new ChangeSet();
        batchUpdate.setDeleteCiIds(roesToDelete);
        return batchUpdate;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                ChangeSet changeset = UndeploymentTask.this.determineRepositoryChanges();
                UndeploymentTask.this.repositoryService.execute(changeset);
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.UNDEPLOY;
    }
}

