/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.security.LdapContextFactory;
import com.xebialabs.deployit.security.LdapPrincipalProvider;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapLoginModule
implements LoginModule {
    private static final String USER_PROVIDER = "userProvider";
    private static final String USER_FILTER = "userFilter";
    private static final String PRINCIPAL_PROVIDER = "principalProvider";
    private static final String USER_SEARCH_BASE = "userSearchBase";
    private static final String USERNAME_TOKEN = "{USERNAME}";
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\\{USERNAME\\}");
    private static final String USE_SSL = "useSSL";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private Hashtable<String, Object> ldap = new Hashtable();
    private String ldapUrl;
    private String userSearchBase;
    private String userFilter = "(&(uid={USERNAME})(objectclass=inetOrgPerson))";
    private Matcher userFilterMatcher;
    private SearchControls constraints;
    private String principalProviderClass = LdapPrincipalProvider.class.getName();
    private AtomicReference<LdapPrincipalProvider> ldapPrincipalProvider = new AtomicReference();
    private LdapLoginState state;
    private static final Logger logger = LoggerFactory.getLogger(LdapLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.ldap.put("java.naming.factory.initial", LdapContextFactory.class.getName());
        this.ldap.putAll(Maps.filterKeys(options, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(".");
            }
        }));
        if (options.containsKey(USER_PROVIDER)) {
            this.ldapUrl = (String)options.get(USER_PROVIDER);
            this.ldap.put("java.naming.provider.url", this.ldapUrl);
        }
        this.userSearchBase = Strings.nullToEmpty((String)((String)options.get(USER_SEARCH_BASE)));
        if (options.containsKey(USER_FILTER)) {
            this.userFilter = (String)options.get(USER_FILTER);
        }
        if (this.userFilter.contains(USERNAME_TOKEN)) {
            this.userFilterMatcher = USERNAME_PATTERN.matcher(this.userFilter);
        }
        this.constraints = new SearchControls();
        this.constraints.setSearchScope(2);
        this.constraints.setReturningAttributes(new String[0]);
        if (options.containsKey(PRINCIPAL_PROVIDER)) {
            this.principalProviderClass = (String)options.get(PRINCIPAL_PROVIDER);
        }
        if (options.containsKey(USE_SSL)) {
            boolean useSSL = Boolean.valueOf((String)options.get(USE_SSL));
            if (useSSL) {
                this.ldap.put("java.naming.security.protocol", "ssl");
            } else {
                this.ldap.remove("java.naming.security.protocol");
            }
        }
        logger.trace("LDAP options:\n URL: '{}'\n user search base: '{}'\n user filter: '{}'\n principal provider: '{}'\n SSL: {}\n", new Object[]{this.ldapUrl, this.userSearchBase, this.userFilter, LdapPrincipalProvider.class.getName(), options.get(USE_SSL)});
    }

    @Override
    public boolean login() throws LoginException {
        this.state = new LdapLoginState();
        logger.trace("Connection to LDAP {}", (Object)this.ldapUrl);
        try {
            logger.trace("Retrieving username and password");
            this.retrieveUsernamePassword();
            this.tryConnect();
            this.searchUser();
            this.authenticateUser();
            this.createPrincipals();
            this.state.loggedIn = true;
            logger.trace("Logged in successfully");
        }
        catch (LoginException le) {
            this.state.clear();
            logger.error("Login exception occurred: ", (Throwable)le);
            throw le;
        }
        return true;
    }

    private void createPrincipals() throws FailedLoginException {
        this.state.principal = new LdapPrincipalProvider.SimplePrincipal(this.state.username);
        try {
            this.state.ldapPrincipal = new LdapPrincipalProvider.LdapPrincipal(this.state.userDN);
        }
        catch (InvalidNameException e) {
            throw new FailedLoginException("Cannot create LdapPrincipal from " + this.state.userDN, e);
        }
    }

    private void authenticateUser() throws FailedLoginException {
        try {
            if (!this.state.ctx.getEnvironment().containsKey("java.naming.security.authentication")) {
                this.state.ctx.addToEnvironment("java.naming.security.authentication", "simple");
            }
            this.state.ctx.addToEnvironment("java.naming.security.principal", this.state.userDN);
            this.state.ctx.addToEnvironment("java.naming.security.credentials", this.state.password);
            this.state.ctx.reconnect(null);
        }
        catch (NamingException e) {
            throw new FailedLoginException("Cannot authenticate user " + this.state.userDN, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchUser() throws FailedLoginException {
        try {
            NamingEnumeration<SearchResult> results = this.state.ctx.search(this.userSearchBase, this.replaceUsername(this.userFilterMatcher, this.userFilter), this.constraints);
            try {
                if (results.hasMoreElements()) {
                    SearchResult result = (SearchResult)results.nextElement();
                    this.state.userDN = result.getNameInNamespace();
                    logger.debug("Found user: {}", (Object)this.state.userDN);
                }
            }
            finally {
                results.close();
            }
        }
        catch (NamingException e) {
            throw new FailedLoginException("Cannot find user in LDAP", e);
        }
    }

    private String replaceUsername(Matcher userFilterMatcher, String userFilter) {
        return userFilterMatcher != null ? userFilterMatcher.replaceAll(this.state.username) : userFilter;
    }

    private void tryConnect() throws FailedLoginException {
        try {
            this.state.ctx = new InitialLdapContext(this.ldap, null);
        }
        catch (NamingException e) {
            throw new FailedLoginException("Cannot connect to LDAP " + this.ldapUrl, e);
        }
    }

    private void retrieveUsernamePassword() {
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("username; "), new PasswordCallback("password: ", false)};
            this.callbackHandler.handle(callbacks);
            this.state.username = ((NameCallback)callbacks[0]).getName();
            LdapLoginState.access$302(this.state, ((PasswordCallback)callbacks[1]).getPassword());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnsupportedCallbackException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.state.loggedIn) {
            this.checkSubject();
            Set<Principal> principals = this.subject.getPrincipals();
            this.addIfNotContained(principals, this.state.ldapPrincipal);
            this.addIfNotContained(principals, this.state.principal);
            this.getGroupPrincipals(principals);
            this.state.clear();
            this.state.committed = true;
            return true;
        }
        return false;
    }

    private void getGroupPrincipals(Set<Principal> principalsCollector) {
        logger.trace("Getting group principals for {}", (Object)this.state.ldapPrincipal);
        LdapPrincipalProvider ldapPrincipalProvider = this.getPrincipalProvider();
        PrincipalIterator groupMemberships = ldapPrincipalProvider.getGroupMembership(this.state.ldapPrincipal);
        while (groupMemberships.hasNext()) {
            Principal nextPrincipal = groupMemberships.nextPrincipal();
            logger.trace("Adding group principal {}", (Object)nextPrincipal.getName());
            this.addIfNotContained(principalsCollector, nextPrincipal);
        }
        this.addIfNotContained(principalsCollector, (Principal)EveryonePrincipal.getInstance());
    }

    private LdapPrincipalProvider getPrincipalProvider() {
        LdapPrincipalProvider principalProvider = this.ldapPrincipalProvider.get();
        if (principalProvider == null) {
            logger.debug("Instantiating provider class '{}'", (Object)this.principalProviderClass);
            principalProvider = (LdapPrincipalProvider)LdapLoginModule.newInstance(this.principalProviderClass);
            principalProvider.init(LdapLoginModule.toProperties(this.options));
            this.ldapPrincipalProvider.compareAndSet(null, principalProvider);
        }
        return this.ldapPrincipalProvider.get();
    }

    private static Object newInstance(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Unable to instantiate principal provider class '%s'", className), exception);
        }
    }

    private static Properties toProperties(Map<String, ?> propertyEntries) {
        Properties properties = new Properties();
        properties.putAll(propertyEntries);
        return properties;
    }

    private void addIfNotContained(Set<Principal> principals, Principal principal) {
        if (!principals.contains(principal)) {
            principals.add(principal);
        }
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.state.loggedIn && this.state.committed) {
            this.logout();
        } else if (this.state.loggedIn) {
            this.state.loggedIn = false;
            this.state.clear();
            this.state.clearPrincipals();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.state == null) {
            return true;
        }
        this.checkSubject();
        Set<Principal> principals = this.subject.getPrincipals();
        if (principals != null) {
            principals.remove(this.state.ldapPrincipal);
            principals.remove(this.state.principal);
        }
        this.state.clear();
        this.state.loggedIn = false;
        this.state.committed = false;
        this.state.clearPrincipals();
        return true;
    }

    private void checkSubject() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.state.clear();
            throw new LoginException("Subject is readOnly");
        }
    }

    private static class FailedLoginException
    extends LoginException {
        private FailedLoginException(String msg, Exception cause) {
            super(msg);
            this.initCause(cause);
        }
    }

    private class LdapLoginState {
        private String username;
        private char[] password;
        public InitialLdapContext ctx;
        public String userDN;
        public LdapPrincipalProvider.SimplePrincipal principal;
        public LdapPrincipalProvider.LdapPrincipal ldapPrincipal;
        public boolean loggedIn;
        public boolean committed;

        private LdapLoginState() {
        }

        public void clear() {
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            Arrays.fill(this.password, '*');
        }

        public void clearPrincipals() {
            this.ldapPrincipal = null;
            this.principal = null;
        }

        static /* synthetic */ char[] access$302(LdapLoginState x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }
}

