/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.internal.Root;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class JackrabbitRepositoryFactoryBean
implements InitializingBean,
FactoryBean<Repository>,
DisposableBean {
    private Resource homeDir;
    private Resource configuration;
    private JackrabbitRepository repository;
    private boolean createHomeDirIfNotExists;
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitRepositoryFactoryBean.class);

    public void afterPropertiesSet() throws IOException, RepositoryException {
        InputSource configurationInputSource = new InputSource(this.configuration.getInputStream());
        File homeDirFile = this.homeDir.getFile();
        if (!homeDirFile.exists() && !this.createHomeDirIfNotExists) {
            throw new RepositoryException("Jackrabbit home dir " + homeDirFile + " does not exist");
        }
        RepositoryConfig repositoryConfig = RepositoryConfig.create((InputSource)configurationInputSource, (String)homeDirFile.getAbsolutePath());
        this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Instantiated JackRabbit repository");
        }
    }

    public void configureJcrRepositoryForDeployit() {
        new JcrTemplate((Repository)this.repository).executeAsAdmin(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
                namespaceRegistry.registerNamespace("deployit", "http://www.xebialabs.com/deployit");
                NodeTypeManager typeManager = session.getWorkspace().getNodeTypeManager();
                JackrabbitRepositoryFactoryBean.this.createMixinNodeType(typeManager, "deployit:configurationItem");
                JackrabbitRepositoryFactoryBean.this.createMixinNodeType(typeManager, "deployit:artifact");
                JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName());
                JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.INFRASTRUCTURE.getRootNodeName());
                JackrabbitRepositoryFactoryBean.this.createRoot(session, Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName());
                JackrabbitRepositoryFactoryBean.this.createMixinNodeType(typeManager, "deployit:task");
                JackrabbitRepositoryFactoryBean.this.createMixinNodeType(typeManager, "deployit:step");
                JackrabbitRepositoryFactoryBean.this.createNode(session, "tasks", new String[0]);
                JackrabbitRepositoryFactoryBean.this.createMixinNodeType(typeManager, "deployit:configuration");
                JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration", new String[]{"deployit:configuration"});
                JackrabbitRepositoryFactoryBean.this.createNode(session, "$configuration/security", new String[0]);
                JackrabbitRepositoryFactoryBean.this.setAccessControlNode("/$configuration", session, new PrivilegeCallback(){

                    @Override
                    public boolean doWithAcl(JackrabbitAccessControlList acl, AccessControlManager acm) throws RepositoryException {
                        Privilege allPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
                        Privilege readPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
                        acl.addEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{allPrivilege}, false);
                        acl.addEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{readPrivilege}, true);
                        return true;
                    }
                });
                JackrabbitRepositoryFactoryBean.this.setAccessControlOnRootNode(session);
                JackrabbitRepositoryFactoryBean.this.setRepoVersion(session);
                return null;
            }
        });
    }

    private void setRepoVersion(Session session) throws RepositoryException {
        Node node = session.getRootNode().addNode("$configuration/versions");
        node.setProperty("deployit", ReleaseInfo.getReleaseInfo().getVersion());
        session.save();
    }

    private void createMixinNodeType(NodeTypeManager typeManager, String nodetypeName) throws RepositoryException {
        NodeTypeTemplate nodeTypeTemplate = typeManager.createNodeTypeTemplate();
        nodeTypeTemplate.setName(nodetypeName);
        nodeTypeTemplate.setQueryable(true);
        nodeTypeTemplate.setAbstract(false);
        nodeTypeTemplate.setMixin(true);
        typeManager.registerNodeType((NodeTypeDefinition)nodeTypeTemplate, false);
    }

    private void createRoot(Session session, String rootNodeName) throws RepositoryException {
        Node node = session.getRootNode().addNode(rootNodeName);
        node.addMixin("deployit:configurationItem");
        node.setProperty("$configuration.item.type", "internal." + Root.class.getSimpleName());
        node.setProperty("$id", rootNodeName);
        node.setProperty("$lastModified", Calendar.getInstance());
        this.setAccessControlNode("/" + rootNodeName, session, new PrivilegeCallback(){

            @Override
            public boolean doWithAcl(JackrabbitAccessControlList acl, AccessControlManager acm) throws RepositoryException {
                Privilege read = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
                EveryonePrincipal everyone = EveryonePrincipal.getInstance();
                for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                    if (!((Object)entry.getPrincipal()).equals(everyone)) continue;
                    acl.removeAccessControlEntry(entry);
                }
                acl.addEntry((Principal)everyone, new Privilege[]{read}, false);
                HashMap restrictions = Maps.newHashMap();
                restrictions.put("rep:glob", ValueFactoryImpl.getInstance().createValue(""));
                acl.addEntry((Principal)everyone, new Privilege[]{read}, true, (Map)restrictions);
                return true;
            }
        });
    }

    private void createNode(Session session, String nodeName, String ... mixinNodeTypeNames) throws RepositoryException {
        Node rootNode = session.getRootNode();
        Node addedNode = rootNode.addNode(nodeName);
        for (String each : mixinNodeTypeNames) {
            addedNode.addMixin(each);
        }
        session.save();
    }

    protected void setAccessControlNode(String node, Session session, PrivilegeCallback callback) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies(node);
        boolean policySet = false;
        while (!policySet && applicablePolicies.hasNext()) {
            AccessControlPolicy each = applicablePolicies.nextAccessControlPolicy();
            if (!(each instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)each;
            policySet = callback.doWithAcl(acl, acm);
            logger.debug("Setting {} on {}", (Object)acl, (Object)node);
            acm.setPolicy(node, (AccessControlPolicy)acl);
        }
        if (!policySet) {
            throw new IllegalStateException("Could not set permission on node " + node);
        }
        session.save();
    }

    protected void setAccessControlOnRootNode(Session session) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies("/");
        boolean policySet = false;
        while (!policySet && applicablePolicies.hasNext()) {
            AccessControlPolicy each = applicablePolicies.nextAccessControlPolicy();
            if (!(each instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)each;
            Privilege readPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            EveryonePrincipal everyone = EveryonePrincipal.getInstance();
            for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                if (!((Object)entry.getPrincipal()).equals(everyone)) continue;
                acl.removeAccessControlEntry(entry);
            }
            acl.addEntry((Principal)everyone, new Privilege[]{readPrivilege}, true);
            logger.debug("Setting {} on root", (Object)acl);
            acm.setPolicy("/", (AccessControlPolicy)acl);
        }
    }

    protected void setAccessControlListOnConfigurationNode(Session session) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies("/$configuration");
        boolean policySet = false;
        while (!policySet && applicablePolicies.hasNext()) {
            AccessControlPolicy each = applicablePolicies.nextAccessControlPolicy();
            if (!(each instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)each;
            for (AccessControlEntry eachEntry : acl.getAccessControlEntries()) {
                acl.removeAccessControlEntry(eachEntry);
            }
            Privilege allPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
            Privilege readPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            acl.addEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{allPrivilege}, false);
            acl.addEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{readPrivilege}, true);
            acm.setPolicy("/$configuration", (AccessControlPolicy)acl);
            policySet = true;
        }
        if (!policySet) {
            throw new IllegalStateException("Could not set permission on preferences node /$configuration");
        }
        session.save();
    }

    public Repository getObject() {
        return this.repository;
    }

    public void destroy() {
        this.repository.shutdown();
    }

    public Class<Repository> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    @Required
    public void setHomeDir(Resource homeDir) {
        this.homeDir = homeDir;
    }

    public Resource getConfiguration() {
        return this.configuration;
    }

    @Required
    public void setConfiguration(Resource configuration) {
        this.configuration = configuration;
    }

    public boolean isCreateHomeDirIfNotExists() {
        return this.createHomeDirIfNotExists;
    }

    public void setCreateHomeDirIfNotExists(boolean autoCreateRepositoryDir) {
        this.createHomeDirIfNotExists = autoCreateRepositoryDir;
    }

    private static interface PrivilegeCallback {
        public boolean doWithAcl(JackrabbitAccessControlList var1, AccessControlManager var2) throws RepositoryException;
    }
}

