package com.xebialabs.deployit.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import java.util.Hashtable;

/**
 * Our own LDAP Context Factory which just tries all the specific implementation until it finds the one your JVM is using.
 */
public class LdapContextFactory implements InitialContextFactory {
    private static final String SUN_ICF_FQCN = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String IBM_ICF_FQCN = "com.ibm.jndi.LDAPCtxFactory";
    private static final String BEA_ICF_FQCN = SUN_ICF_FQCN;  // JRocket might use SUN classes
    private static final String ICF_FQCN;

    private static final Logger logger = LoggerFactory.getLogger(LdapContextFactory.class);
    private InitialContextFactory factory;

    static {
        ICF_FQCN = tryFactory(SUN_ICF_FQCN) ? SUN_ICF_FQCN :
                tryFactory(IBM_ICF_FQCN) ? IBM_ICF_FQCN :
                tryFactory(BEA_ICF_FQCN) ? BEA_ICF_FQCN :
                "unknown";
    }

    private static boolean tryFactory(String fqcn) {
        try {
            Class.forName(fqcn);
            logger.trace("Found LdapContextFactory: {}", fqcn);
            return true;
        } catch (ClassNotFoundException e) {
            logger.debug("Couldn't find LdapContextFactory: {}", fqcn);
        }
        return false;
    }

    public LdapContextFactory() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        factory = (InitialContextFactory) Class.forName(ICF_FQCN).newInstance();
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return factory.getInitialContext(environment);
    }
}
