package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

/**
 * CRUDL for RepositoryEntity and things extending...
 */
public interface RepositoryService {

	<T extends ConfigurationItem> void create(T... entity);

	<T extends ConfigurationItem> T read(String id);

	<T extends ConfigurationItem> T read(String id, WorkDir workDir);

	<T extends ConfigurationItem> void update(T... entity);

	void delete(String... id);

    void execute(ChangeSet changeset);

    void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException;

	List<String> list(SearchParameters criteria);

	<T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters);

	boolean checkNodeExists(String id);

}
