package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import static com.google.common.collect.Maps.newHashMap;

public class NodeReaderContext {

	private static final ThreadLocal<NodeReaderContext> CONTEXT_HOLDER = new ThreadLocal<NodeReaderContext>() {
		@Override
		protected NodeReaderContext initialValue() {
			logger.trace("** Creating new context");
			return new NodeReaderContext();
		}
	};

	private AtomicInteger references = new AtomicInteger(0);
	private Map<String, ConfigurationItem> context = newHashMap();

	private NodeReaderContext() {}

	public static NodeReaderContext get() {
		return CONTEXT_HOLDER.get();
	}

	boolean hasItem(String uuid) {
		return context.containsKey(uuid);
	}

	ConfigurationItem get(String uuid) {
		return context.get(uuid);
	}

	void put(String uuid, ConfigurationItem item) {
		context.put(uuid, item);
	}

	public NodeReaderContext hold() {
		logger.trace("Holding context current leases {}", references);
		references.incrementAndGet();
		return this;
	}

	public void release() {
		logger.trace("Releasing context current leases {}", references);
		if (references.decrementAndGet() <= 0) {
			logger.trace("**Removing context with: {}" + context);
			CONTEXT_HOLDER.remove();
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(NodeReaderContext.class);
}
