/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSource
implements ImportSource {
    private final URL location;
    private FileSource downloaded;
    private static final Logger logger = LoggerFactory.getLogger(UrlSource.class);

    public UrlSource(URL location) {
        this.location = location;
    }

    private void download() {
        try {
            logger.debug("Preparing to download package from {}", (Object)this.location);
            HttpClient client = new HttpClient();
            URI uri = this.location.toURI();
            GetMethod method = new GetMethod(uri.toString());
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new RuntimeIOException("Failed to download package,status=" + statusCode + ", from url " + this.location);
            }
            this.save(uri, method.getResponseBodyAsStream());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        catch (HttpException e) {
            throw new RuntimeIOException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(URI uri, InputStream responseBodyAsStream) throws IOException {
        try {
            String path = uri.getPath();
            String name = new File(path).getName();
            File archive = File.createTempFile(FilenameUtils.getBaseName((String)name), FilenameUtils.getExtension((String)name));
            ByteStreams.copy((InputStream)responseBodyAsStream, (OutputStream)new FileOutputStream(archive));
            this.downloaded = new FileSource(archive, true);
        }
        finally {
            responseBodyAsStream.close();
        }
    }

    public File getFile() {
        if (this.downloaded == null) {
            this.download();
        }
        return this.downloaded.getFile();
    }

    public void cleanUp() {
        if (this.downloaded != null) {
            this.downloaded.cleanUp();
        }
    }

    public String toString() {
        return "UrlSource[" + this.location + "]";
    }
}

