/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private Validator validator;
    private File importablePackageDirectory;
    private List<Importer> importers = Lists.newArrayList();

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, Validator validator) {
        this.repositoryService = repositoryService;
        this.validator = validator;
    }

    @PostConstruct
    public void initImporters() {
        Set importers = ReflectionsHolder.getSubTypesOf(Importer.class);
        for (Class importer : importers) {
            try {
                if (importer.isInterface() || Modifier.isAbstract(importer.getModifiers())) continue;
                this.importers.add((Importer)importer.newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate importer: " + importer, e);
            }
        }
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory = importablePackageDirectory;
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    @Override
    public List<String> listPackages() {
        ArrayList packagesFound = Lists.newArrayList();
        for (Importer importer : this.importers) {
            if (!(importer instanceof ListableImporter)) continue;
            packagesFound.addAll(((ListableImporter)importer).list(this.importablePackageDirectory));
        }
        Collections.sort(packagesFound);
        return packagesFound;
    }

    @Override
    public String importPackage(ImportSource source) {
        try {
            for (Importer importer : this.importers) {
                if (!importer.canHandle(source)) continue;
                String string = this.doImport(source, importer);
                return string;
            }
            throw new ImporterException("Unable to obtain the package to import from the import source", new Object[0]);
        }
        finally {
            source.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doImport(ImportSource source, Importer importer) {
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        boolean isUpgrade = this.isUpgrade(packageInfo);
        this.checkPermission(isUpgrade, packageInfo);
        this.checkImported(packageInfo);
        try {
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage.getDeployables());
            List<ConfigurationItem> toCreate = this.createEntities(importedPackage, isUpgrade);
            this.validate(toCreate);
            this.repositoryService.create(toCreate.toArray(new ConfigurationItem[toCreate.size()]));
            String string = importedPackage.getDeploymentPackage().getId();
            return string;
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
    }

    private void scanPlaceholders(List<Deployable> deployables) {
        for (Deployable deployable : deployables) {
            if (!(deployable instanceof SourceArtifact)) continue;
            ((SourceArtifact)deployable).initPlaceholders((PlaceholderScanner)new MustachePlaceholderScanner());
        }
    }

    private void checkImported(PackageInfo packageInfo) {
        if (this.repositoryService.checkNodeExists(IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion()))) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
    }

    private List<ConfigurationItem> createEntities(ImportedPackage importedPackage, boolean isUpgrade) {
        ArrayList toCreate = Lists.newArrayList();
        if (!isUpgrade) {
            toCreate.add(importedPackage.getApplication());
        }
        toCreate.add(importedPackage.getDeploymentPackage());
        toCreate.addAll(importedPackage.getDeployables());
        return toCreate;
    }

    private void validate(List<ConfigurationItem> toCreate) {
        ArrayList msgs = Lists.newArrayList();
        for (ConfigurationItem toCreateEntity : toCreate) {
            msgs.addAll(this.validator.validate(toCreateEntity, toCreate));
        }
        if (!msgs.isEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", ((Object)msgs).toString());
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        return this.repositoryService.checkNodeExists(packageInfo.getApplicationId());
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        if (isUpgrade) {
            this.checkPermission(Permission.IMPORT_UPGRADE, Lists.newArrayList((Object[])new String[]{packageInfo.getApplicationId()}));
        } else {
            this.checkPermission(Permission.IMPORT_INITIAL, Lists.newArrayList());
        }
    }

    void checkPermission(Permission permission, ArrayList<String> onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission(permission, onConfigurationItems);
        }
    }
}

