/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import java.util.Collection;
import java.util.List;

public class InitialDeploymentHandler
extends PermissionHandler {
    @Override
    protected void handle(String user, PermissionHandler.Action action) {
        this.permission(Permission.DEPLOY_INITIAL, user, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    protected void handle(String user, String onConfigurationItem, PermissionHandler.Action action) {
        Checks.checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
        this.permission(Permission.DEPLOY_INITIAL, user, onConfigurationItem, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
        Environment objectEntity = (Environment)RepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
        Function<ConfigurationItem, String> function = new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        };
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, Collections2.transform((Collection)objectEntity.getMembers(), (Function)function), action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, Collections2.transform((Collection)objectEntity.getDictionaries(), (Function)function), action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    Permission getPermission() {
        return Permission.DEPLOY_INITIAL;
    }
}

