/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.LdapContextFactory;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPrincipalProvider
implements PrincipalProvider {
    private String userProvider;
    private String groupFilter = "uniqueMember={DN}";
    private static final String DN_TOKEN = "{DN}";
    private static final Pattern DN_PATTERN = Pattern.compile("\\{DN\\}");
    private Hashtable<String, String> ldapEnvironment;
    private static final Map<Principal, List<Principal>> groupCache = new MapMaker().expireAfterAccess(10L, TimeUnit.SECONDS).makeMap();
    private static final Logger logger = LoggerFactory.getLogger(LdapPrincipalProvider.class);

    public void init(Properties options) {
        this.userProvider = (String)options.get("userProvider");
        logger.debug("Initialized with userProvider={}", (Object)this.userProvider);
        if (options.containsKey("groupFilter")) {
            this.groupFilter = (String)options.get("groupFilter");
        }
        logger.debug("Configured groupFilter: " + this.groupFilter);
        this.ldapEnvironment = new Hashtable();
        this.ldapEnvironment.put("java.naming.factory.initial", LdapContextFactory.class.getName());
        this.ldapEnvironment.put("java.naming.provider.url", this.userProvider);
        for (Object o : options.keySet()) {
            if (!((String)o).contains(".")) continue;
            logger.debug("Adding key to ldapEnvironment: {}", o);
            this.ldapEnvironment.put((String)o, options.getProperty((String)o));
        }
    }

    public void close() {
    }

    public Principal getPrincipal(String principalName) {
        logger.debug("Getting principal for {}", (Object)principalName);
        try {
            return new LdapPrincipal(principalName);
        }
        catch (InvalidNameException e) {
            logger.debug("Could not create LdapPrincipal for {}, returning UnknownPrincipal", (Object)principalName);
            return new UnknownPrincipal(principalName);
        }
    }

    public PrincipalIterator getPrincipals(int searchType) {
        throw new UnsupportedOperationException("Cannot invoke getPrincipals(int) on LdapPrincipalProvider: not implemented.");
    }

    public boolean canReadPrincipal(Session session, Principal principalToRead) {
        return true;
    }

    public PrincipalIterator findPrincipals(String simpleFilter) {
        throw new UnsupportedOperationException("Cannot invoke findPrincipals(String) on LdapPrincipalProvider: not implemented.");
    }

    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        throw new UnsupportedOperationException("Cannot invoke findPrincipals(String, int) on LdapPrincipalProvider: not implemented.");
    }

    public PrincipalIterator getGroupMembership(Principal principal) {
        logger.trace("getGroupMembership invoked with {}", (Object)principal);
        if (groupCache.containsKey(principal)) {
            logger.debug("Cache hit for {}", (Object)principal);
            return new PrincipalIteratorAdapter((Collection)groupCache.get(principal));
        }
        return new PrincipalIteratorAdapter(this.getLoginGroupMembership(principal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends Principal> getLoginGroupMembership(Principal principal) {
        ArrayList arrayList;
        logger.trace("Getting group membership for principal {}", (Object)principal);
        if (!(principal instanceof LdapPrincipal)) {
            logger.debug("Expected principal of type {} but was of type {}, so returning empty set", LdapPrincipal.class, principal.getClass());
            groupCache.put(principal, Lists.newArrayList());
            return ImmutableList.of();
        }
        logger.trace("Opening initial dir context to {}", (Object)this.userProvider);
        InitialDirContext dc = new InitialDirContext(new Hashtable<String, String>(this.ldapEnvironment));
        try {
            ArrayList groupPrincipals = Lists.newArrayList();
            String memberName = principal.getName();
            this.collectGroupsForMember(principal, dc, memberName, groupPrincipals);
            groupCache.put(principal, groupPrincipals);
            arrayList = groupPrincipals;
        }
        catch (Throwable throwable) {
            try {
                dc.close();
                throw throwable;
            }
            catch (NamingException exc) {
                throw new RuntimeException("Cannot retrieve groups from LDAP server", exc);
            }
        }
        dc.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGroupsForMember(Principal principal, DirContext dc, String memberDn, List<Principal> groupPrincipalsCollector) throws NamingException {
        logger.trace("Getting groups for member dn {} of principal {} from dir context {} and adding it to collector {}", new Object[]{memberDn, dc, principal, groupPrincipalsCollector});
        ArrayList dnsFound = Lists.newArrayList();
        SearchControls controls = new SearchControls(2, 0L, 0, null, false, false);
        String filter = this.groupFilter;
        if (this.groupFilter.contains(DN_TOKEN)) {
            Matcher dnMatcher = DN_PATTERN.matcher(this.groupFilter);
            filter = dnMatcher.replaceAll(memberDn);
        }
        logger.trace("Search dir context {} with name in namespace {} for filter {} with controls {}", new Object[]{dc, dc.getNameInNamespace(), filter, controls});
        NamingEnumeration<SearchResult> groupsFound = dc.search("", filter, controls);
        try {
            while (groupsFound.hasMore()) {
                SearchResult group = groupsFound.next();
                logger.debug("Found group with dn {}, getting cn", (Object)group);
                dnsFound.add(group.getNameInNamespace());
                Attribute cn = group.getAttributes().get("cn");
                logger.debug("Found group with dn {} with cn {} with value {}", new Object[]{group, cn, cn.get()});
                groupPrincipalsCollector.add((Principal)((Object)new LdapGroup(principal, (String)cn.get())));
            }
        }
        finally {
            groupsFound.close();
        }
        for (String each : dnsFound) {
            logger.trace("Invoking recursively for dn {}", (Object)each);
            this.collectGroupsForMember(principal, dc, each, groupPrincipalsCollector);
            logger.trace("End of recursive invocation for dn {}", (Object)each);
        }
    }

    public static final class SimplePrincipal
    implements Principal {
        private String name;

        public SimplePrincipal(String name) {
            Checks.checkNotNull(name, "Name cannot be null");
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimplePrincipal that = (SimplePrincipal)o;
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static final class LdapPrincipal
    implements Principal,
    Serializable {
        private final LdapName ldapName;
        private final String name;

        public LdapPrincipal(String name) throws InvalidNameException {
            Checks.checkNotNull(name, "Name of a principal cannot be null");
            this.ldapName = new LdapName(name);
            this.name = name;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Principal) {
                try {
                    return this.ldapName.equals(new LdapName(((Principal)object).getName()));
                }
                catch (InvalidNameException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.ldapName.hashCode();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.ldapName.toString();
        }
    }

    public static class LdapGroup
    implements Group {
        private Principal member;
        private String cn;

        public LdapGroup(Principal member, String cn) {
            this.member = member;
            this.cn = cn;
        }

        public String getName() {
            return this.cn;
        }

        public boolean addMember(Principal user) {
            throw new UnsupportedOperationException("Cannot add a member to an LdapGroup. Use LDAP directly.");
        }

        public boolean removeMember(Principal user) {
            throw new UnsupportedOperationException("Cannot remove a member from an LdapGroup. Use LDAP directly.");
        }

        public boolean isMember(Principal member) {
            return member.getName().equals(this.member.getName());
        }

        public Enumeration<? extends Principal> members() {
            return new Vector<Principal>(Collections.singleton(this.member)).elements();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LdapGroup ldapGroup = (LdapGroup)o;
            if (this.cn != null ? !this.cn.equals(ldapGroup.cn) : ldapGroup.cn != null) {
                return false;
            }
            return !(this.member != null ? !((Object)this.member).equals(ldapGroup.member) : ldapGroup.member != null);
        }

        public int hashCode() {
            int result = this.member != null ? ((Object)this.member).hashCode() : 0;
            result = 31 * result + (this.cn != null ? this.cn.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LdapGroup[" + this.cn + ": " + this.member + "]";
        }
    }
}

