/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.PermissionService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.util.Tuple;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="permissionService")
public class JcrPermissionService
implements PermissionService {
    protected JcrTemplate jcrTemplate;
    private Function<Value, String> valueToStringFunction = new Function<Value, String>(){

        public String apply(Value input) {
            try {
                return input.getString();
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Something wrong with the security in the repository; Could not get String from value " + input, e);
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JcrPermissionService.class);

    @Autowired
    public JcrPermissionService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public Map<String, Set<String>> getUserPermissions(final String principalName) {
        return this.jcrTemplate.execute(new JcrCallback<Map<String, Set<String>>>(){

            @Override
            public Map<String, Set<String>> doInJcr(Session session) throws IOException, RepositoryException {
                TreeMap<String, Set<String>> userPermissions = new TreeMap<String, Set<String>>();
                Node securityNode = (Node)Preconditions.checkNotNull((Object)session.getNode("/$configuration/security"));
                PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
                Principal principal = principalManager.getPrincipal(session.getUserID());
                if (principal.getName().equals(principalName) || principal instanceof AdminPrincipal) {
                    List groups = JcrPermissionService.this.getGroupMemberships(principalManager, principalManager.getPrincipal(principalName));
                    for (String permission : JcrPermissionService.this.getAllowedPermissions(securityNode, groups, principalName)) {
                        Tuple<Permission, String> deconstructedPermission = PermissionHelper.decodePermissionString(permission);
                        String permissionName = ((Permission)((Object)deconstructedPermission.a)).getPermissionName();
                        if (!userPermissions.containsKey(permissionName)) {
                            userPermissions.put(permissionName, Sets.newTreeSet());
                        }
                        if (((String)deconstructedPermission.b).length() == 0) {
                            ((Set)userPermissions.get(permissionName)).add("");
                            continue;
                        }
                        ((Set)userPermissions.get(permissionName)).add(((String)deconstructedPermission.b).replace("$", "/"));
                    }
                } else {
                    throw new RepositoryException("Insufficient permissions for retrieving a user's or group's permissions");
                }
                return userPermissions;
            }
        });
    }

    @Override
    public boolean hasUserPermission(final String permissionName, final String principalName) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
                Principal principal = principalManager.getPrincipal(principalName);
                if (JcrPermissionService.this.isAdmin(principal, permissionName)) {
                    return true;
                }
                List groups = JcrPermissionService.this.getGroupMemberships(principalManager, principal);
                return JcrPermissionService.this.checkHasPermission(session, groups, principalName, permissionName);
            }
        });
    }

    @Override
    public boolean hasLoggedInUserPermission(final String permissionName) {
        final Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                Subject subject = ((SessionImpl)session).getSubject();
                PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
                ArrayList groups = Lists.newArrayList();
                for (Principal eachPrincipal : subject.getPrincipals()) {
                    if (JcrPermissionService.this.isAdmin(eachPrincipal, permissionName)) {
                        return true;
                    }
                    groups.addAll(JcrPermissionService.this.getGroupMemberships(principalManager, eachPrincipal));
                }
                String principalName = auth.getName();
                return JcrPermissionService.this.checkHasPermission(session, groups, principalName, permissionName);
            }
        });
    }

    private boolean isAdmin(Principal eachPrincipal, String permissionName) {
        if (eachPrincipal instanceof AdminPrincipal) {
            logger.debug("Granted {} because user is admin.", (Object)permissionName);
            return true;
        }
        return false;
    }

    private Boolean checkHasPermission(Session session, List<String> groups, String principalName, String permissionName) throws RepositoryException {
        Node securityNode = (Node)Preconditions.checkNotNull((Object)session.getNode("/$configuration/security"));
        Set<String> permissions = this.getAllowedPermissions(securityNode, groups, principalName);
        return permissions.contains(permissionName);
    }

    private Set<String> getAllowedPermissions(Node securityNode, List<String> groups, String principalName) {
        HashSet permissions = Sets.newHashSet();
        this.addAllPermissionsToSet(principalName, permissions, securityNode);
        for (String group : groups) {
            this.addAllPermissionsToSet(group, permissions, securityNode);
        }
        return permissions;
    }

    private void addAllPermissionsToSet(String principal, Set<String> permissions, Node securityNode) {
        try {
            Property node = securityNode.getProperty(principal);
            permissions.addAll(Lists.transform((List)Lists.newArrayList((Object[])node.getValues()), this.valueToStringFunction));
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    @Override
    public void grantPermission(final String permissionName, final String principal) {
        logger.debug("Granting {} to {}", (Object)permissionName, (Object)principal);
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node securityNode = (Node)Preconditions.checkNotNull((Object)session.getNode("/$configuration/security"));
                Set permissions = JcrPermissionService.this.getAllowedPermissions(securityNode, Lists.newArrayList(), principal);
                permissions.add(permissionName);
                JcrPermissionService.this.setPermissionsForPrincipal(securityNode, principal, permissions);
                session.save();
                return null;
            }
        });
    }

    @Override
    public void denyPermission(final String permissionName, final String principal) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node securityNode = (Node)Preconditions.checkNotNull((Object)session.getNode("/$configuration/security"));
                Set permissions = JcrPermissionService.this.getAllowedPermissions(securityNode, Lists.newArrayList(), principal);
                permissions.remove(permissionName);
                JcrPermissionService.this.setPermissionsForPrincipal(securityNode, principal, permissions);
                session.save();
                return null;
            }
        });
    }

    private void setPermissionsForPrincipal(Node securityNode, String principal, Set<String> permissions) throws RepositoryException {
        securityNode.setProperty(principal, Lists.transform((List)Lists.newArrayList(permissions), (Function)new Function<String, Value>(){

            public Value apply(String input) {
                return new StringValue(input);
            }
        }).toArray(new Value[permissions.size()]));
    }

    private List<String> getGroupMemberships(PrincipalManager principalManager, Principal principal) {
        ArrayList groups = Lists.newArrayList();
        if (principal != null) {
            Iterators.addAll((Collection)groups, (Iterator)Iterators.transform((Iterator)principalManager.getGroupMembership(principal), (Function)new Function<Principal, String>(){

                public String apply(Principal input) {
                    return input.getName();
                }
            }));
        }
        return groups;
    }
}

