package com.xebialabs.deployit.task.controltask;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.task.Task;

import java.util.List;
import java.util.concurrent.CountDownLatch;

@SuppressWarnings("serial")
public class ControlTask extends Task {

	private transient CountDownLatch latch = new CountDownLatch(1);

	public ControlTask(final List<? extends Step<?>> steps) {
		super(steps);
	}

	@Override
	public void processAfterRecovery() {
		super.processAfterRecovery();
		latch = new CountDownLatch(1);
	}

	@Override
	public void doAfterTaskStateChangedToDone() {
		latch.countDown();
	}

	@Override
	public void doAfterTaskStateChangedToAborted() {
		latch.countDown();
	}

	public void awaitFinish() {
		try {
			latch.await();
		} catch (InterruptedException e) {
			getWrappingTask().cancel(true);
			Thread.currentThread().interrupt();
		}
	}
}
