package com.xebialabs.deployit.service.discovery;

import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.task.ExecutionContextAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class DiscoveryService {

	private final Inspector inspector;

	@Autowired
	public DiscoveryService(Inspector inspector) {
		this.inspector = inspector;
	}

	public List<ConfigurationItem> discoverConfigurationItem(final ConfigurationItem ci) {
		ExecutionContextAttributes executionContext = new ExecutionContextAttributes();
		try {
			List<ConfigurationItem> discovered = inspector.inspect(ci, executionContext.getAttributes());
			return discovered;
		} finally {
			executionContext.destroy();
		}
	}

}
