package com.xebialabs.deployit.security;

import java.util.Map;
import java.util.Set;

public interface PermissionService {

	Map<String, Set<String>> getUserPermissions(final String principalName);

	boolean hasUserPermission(String permissionName, String principalName);

	boolean hasLoggedInUserPermission(String permissionName);

	void grantPermission(String permissionName, String principal);

	void denyPermission(String permissionName, String principal);
}
