package com.xebialabs.deployit.security;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

public class JcrAccessControlEntry {

	private String principalName;

	private boolean allow;

	private List<String> privileges;
	private boolean transitive = true;

	public JcrAccessControlEntry(String principalName, boolean allow, String... privileges) {
		this(principalName, allow, newArrayList(privileges));
	}

	public JcrAccessControlEntry(String principalName, boolean allow, List<String> privileges) {
		this.principalName = principalName;
		this.allow = allow;
		this.privileges = privileges;
	}

	public JcrAccessControlEntry(String principalName, boolean allow, List<String> privileges, boolean transitive) {
		this.allow = allow;
		this.principalName = principalName;
		this.privileges = privileges;

		this.transitive = transitive;
	}

	public String getPrincipalName() {
		return principalName;
	}

	public boolean isAllow() {
		return allow;
	}

	public List<String> getPrivileges() {
		return privileges;
	}

	@Override
	public String toString() {
		return (allow ? "" : "Not ") + privileges + " for " + principalName;
	}

	public boolean isTransitive() {
		return transitive;
	}
}
