package com.xebialabs.deployit.repository;

import org.apache.jackrabbit.spi.commons.value.QValueValue;

import javax.jcr.*;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;

import static com.xebialabs.deployit.repository.JcrPathHelper.getIdFromAbsolutePath;
import static javax.jcr.nodetype.NodeType.NT_FROZEN_NODE;
import static javax.jcr.query.Query.JCR_SQL2;
import static org.apache.jackrabbit.JcrConstants.JCR_FROZENUUID;

public class NodeUtils {

	static Node getReferencedCiNode(Node node, Value value, Session session) throws RepositoryException {
		String referencedCiUuid = ((QValueValue) value).getQValue().getString();
		return getNodeByUuid(node, referencedCiUuid, session);
	}

	static String getReferencedCiId(Node node, Value value, Session session) throws RepositoryException {
		return getIdFromAbsolutePath(getReferencedCiNode(node, value, session).getPath());
	}

	protected static Node getNodeByUuid(Node node, String referencedCiUuid, Session session) throws RepositoryException {
		try {
			return session.getNodeByIdentifier(referencedCiUuid);
		} catch (ItemNotFoundException exc) {
			if (nodeIsFrozen(node)) {
				Node frozenNode = getFrozenNodeByUuid(referencedCiUuid, session);
				if (frozenNode != null) {
					return frozenNode;
				}
			}
			throw exc;
		}
	}

	static Node getFrozenNodeByUuid(String uuid, Session session) throws RepositoryException {
		QueryManager queryManager = session.getWorkspace().getQueryManager();
		ValueFactory valueFactory = session.getValueFactory();

		Query query = queryManager.createQuery("SELECT * FROM [" + NT_FROZEN_NODE + "] WHERE [" + JCR_FROZENUUID + "] = $uuid", JCR_SQL2);
		query.bindValue("uuid", valueFactory.createValue(uuid));
		QueryResult result = query.execute();
		NodeIterator resultNodes = result.getNodes();
		while (resultNodes.hasNext()) {
			// Assuming that a query by UUID only return one node
			return resultNodes.nextNode();
		}
		return null;
	}

	static boolean nodeIsFrozen(Node node) throws RepositoryException {
		return node.isNodeType(NodeType.NT_FROZEN_NODE);
	}


}
