/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import java.util.Collection;
import java.util.Map;

public class ConsolidatedDictionary {
    private Map<String, String> entries = Maps.newHashMap();

    public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
        ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
        if (dicts != null) {
            for (Dictionary dict : dicts) {
                dictionary.addDictionary(dict);
            }
        }
        return dictionary;
    }

    void addDictionary(Dictionary d) {
        for (String k : d.getEntries().keySet()) {
            if (this.entries.containsKey(k) && !this.entries.get(k).equals(d.getEntries().get(k))) {
                throw new IllegalArgumentException("Flattened Dictionary already contains a value for key " + k);
            }
            this.entries.put(k, (String)d.getEntries().get(k));
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public String get(String key) {
        return this.entries.get(key);
    }

    public Object resolve(Object value) throws DictionaryValueException {
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries);
        if (value != null && value instanceof String) {
            value = placeholderReplacer.replace((String)value);
        }
        return value;
    }
}

