/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamSource
implements ImportSource {
    private final String fileName;
    private final InputStream stream;
    private FileSource file;

    public InputStreamSource(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
    }

    public File getFile() {
        if (this.file == null) {
            this.streamToTempFile();
        }
        return this.file.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamToTempFile() {
        try {
            String fileName = this.fileName;
            int slash = fileName.lastIndexOf(47);
            if (slash != -1 && slash != fileName.length() - 1) {
                fileName = fileName.substring(slash);
            }
            int dot = fileName.lastIndexOf(".");
            String namePart = fileName;
            String extension = ".dar";
            if (dot != -1) {
                namePart = fileName.substring(0, dot);
                extension = fileName.substring(dot);
            }
            File tempFile = File.createTempFile(namePart, extension);
            FileOutputStream to = new FileOutputStream(tempFile);
            try {
                ByteStreams.copy((InputStream)this.stream, (OutputStream)to);
            }
            finally {
                Closeables.closeQuietly((Closeable)to);
            }
            this.file = new FileSource(tempFile, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void cleanUp() {
        if (this.file != null) {
            this.file.cleanUp();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.file != null ? this.file : "no file on disk") + "]";
    }
}

