/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.exception.DeployitException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class PasswordObfuscator {
    private static final byte[] KEY_BYTES = new byte[]{-29, -22, 22, -81, -108, 95, 91, 23, 46, -26, 49, -45, -64, 112, 39, -42};
    private static final SecretKeySpec AES_KEY = new SecretKeySpec(KEY_BYTES, "AES");
    private static final Base64Coder BASE_64_CODER = new Base64Coder();

    public static boolean isEncoded(String password) {
        try {
            BASE_64_CODER.decode(password.getBytes());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isEncrypted(String password) {
        if (PasswordObfuscator.isEncoded(password)) {
            byte[] decode = BASE_64_CODER.decode(password.getBytes());
            try {
                Cipher cipher = PasswordObfuscator.getCipher(2);
                cipher.doFinal(decode);
                return true;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    public static String encrypt(String password) {
        Checks.checkArgument(password != null, "The password is null", new Object[0]);
        Checks.checkArgument(!password.startsWith(BASE_64_CODER.identifier()), "The password contains the illegal sequence " + BASE_64_CODER.identifier(), new Object[0]);
        try {
            Cipher aes = PasswordObfuscator.getCipher(1);
            return new String(BASE_64_CODER.encode(aes.doFinal(password.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not encrypt the password using AES 128");
        }
    }

    public static String decrypt(String encryptedPassword) {
        Checks.checkArgument(encryptedPassword != null, "The password is null", new Object[0]);
        Checks.checkArgument(encryptedPassword.startsWith(BASE_64_CODER.identifier()), "The password should be Base64 encoded", new Object[0]);
        try {
            Cipher aes = PasswordObfuscator.getCipher(2);
            return new String(aes.doFinal(BASE_64_CODER.decode(encryptedPassword.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not decrypt the password using AES 128");
        }
    }

    private static Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance("AES");
        aes.init(mode, AES_KEY);
        return aes;
    }

    public static String ensureEncrypted(String password) {
        if (PasswordObfuscator.isEncrypted(password)) {
            return password;
        }
        return PasswordObfuscator.encrypt(password);
    }
}

