/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.deployment.InitialDeploymentTask;
import com.xebialabs.deployit.task.deployment.UndeploymentTask;
import com.xebialabs.deployit.task.deployment.UpgradeDeploymentTask;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentService {
    private PojoConverter pojoConverter;
    private RepositoryService repositoryService;
    private Planner planner;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(PojoConverter pojoConverter, RepositoryService repositoryService, Planner planner) {
        this.pojoConverter = pojoConverter;
        this.repositoryService = repositoryService;
        this.planner = planner;
    }

    public Task prepareInitialDeployment(ConfigurationItemEntity pkgEntity, ConfigurationItemEntity envEntity, Collection<ConfigurationItemEntity> deployeds) {
        PojoConverter.Context converter = this.pojoConverter.getContext();
        DeploymentPackage pkg = (DeploymentPackage)converter.toPojo(pkgEntity);
        Environment env = (Environment)converter.toPojo(envEntity);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial((Version)pkg, env);
        Set<Deployed> deployedPojos = this.convertIncomingDeployeds(deployeds, converter);
        DeploymentOperationCalculator.calculate(builder, Sets.newHashSet(), deployedPojos);
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        return new InitialDeploymentTask(specification, plan.getSteps(), this.repositoryService, this.pojoConverter, converter);
    }

    public Task prepareUpgradeDeployment(ConfigurationItemEntity newPkgEntity, ConfigurationItemEntity existingDeploymentEntity, Collection<ConfigurationItemEntity> deployeds) {
        PojoConverter.Context oldConverterContext = this.pojoConverter.getContext();
        DeployedApplication existingDeployment = (DeployedApplication)oldConverterContext.toPojo(existingDeploymentEntity);
        PojoConverter.Context newConverterContext = this.pojoConverter.getContext();
        DeploymentPackage newPkg = (DeploymentPackage)newConverterContext.toPojo(newPkgEntity);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().upgrade((Version)newPkg, existingDeployment);
        Set<Deployed> incomingDeployedPojos = this.convertIncomingDeployeds(deployeds, newConverterContext);
        DeploymentOperationCalculator.calculate(builder, existingDeployment.getDeployeds(), incomingDeployedPojos);
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        return new UpgradeDeploymentTask(specification, existingDeployment, plan.getSteps(), this.repositoryService, this.pojoConverter, oldConverterContext, newConverterContext);
    }

    private Set<Deployed> convertIncomingDeployeds(Collection<ConfigurationItemEntity> deployeds, PojoConverter.Context converter) {
        Collection pojos = converter.toPojo(deployeds);
        return Sets.newHashSet(pojos);
    }

    public Task prepareUndeployment(ConfigurationItemEntity deployedApplicationEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        DeployedApplication deployedApplication = (DeployedApplication)pojoConverterContext.toPojo(deployedApplicationEntity);
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, deployedApplication.getDeployeds(), Sets.newHashSet());
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        return new UndeploymentTask(specification, deployedApplication, plan.getSteps(), this.repositoryService, this.pojoConverter, pojoConverterContext);
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class DeploymentException
    extends DeployitException {
        public DeploymentException(String message) {
            super(message);
        }
    }
}

