/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DeployedGenerator.class);

    public Type findMostSpecificDeployedTypeForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        List<Type> deployedTypesForDeployableAndContainer = this.findDeployedTypesForDeployableAndContainerTypes(deployableType, containerType);
        if (deployedTypesForDeployableAndContainer.isEmpty()) {
            return null;
        }
        if (deployedTypesForDeployableAndContainer.size() == 1) {
            return deployedTypesForDeployableAndContainer.get(0);
        }
        List<Type> copy = this.filterMostSpecific(deployedTypesForDeployableAndContainer);
        if (copy.size() == 1) {
            return copy.get(0);
        }
        throw new IllegalArgumentException(String.format("Found %s for %s and %s, expected only 1", copy, deployableType, containerType));
    }

    List<Type> filterMostSpecific(List<Type> deployedTypesForDeployableAndContainer) {
        ArrayList copy = Lists.newArrayList(deployedTypesForDeployableAndContainer);
        for (Type currentType : deployedTypesForDeployableAndContainer) {
            Descriptor currentDescriptor = DescriptorRegistry.getDescriptor((Type)currentType);
            Iterator copyIt = copy.iterator();
            while (copyIt.hasNext()) {
                Type comparedType = (Type)copyIt.next();
                Descriptor comparedDescriptor = DescriptorRegistry.getDescriptor((Type)comparedType);
                boolean deployableEquals = comparedDescriptor.getDeployableType().equals((Object)currentDescriptor.getDeployableType());
                boolean containerEquals = comparedDescriptor.getContainerType().equals((Object)currentDescriptor.getContainerType());
                boolean containerSupertype = this.isSubType(comparedDescriptor.getContainerType(), currentDescriptor.getContainerType());
                boolean deployableSupertype = this.isSubType(comparedDescriptor.getDeployableType(), currentDescriptor.getDeployableType());
                boolean isSupertype = this.isSubType(comparedType, currentType);
                if (!(containerSupertype && deployableEquals || deployableSupertype && containerEquals || deployableSupertype && containerSupertype) && !isSupertype) continue;
                copyIt.remove();
            }
        }
        return copy;
    }

    private boolean isSubType(Type superType, Type subType) {
        return DescriptorRegistry.getSubtypes((Type)superType).contains(subType);
    }

    public List<Type> findDeployedTypesForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        Collection deployedTypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Deployed.class));
        final Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployableType);
        final Descriptor containerDesc = DescriptorRegistry.getDescriptor((Type)containerType);
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)deployedTypes, (Predicate)new Predicate<Type>(){

            public boolean apply(Type input) {
                Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)input);
                return !deployedDesc.isVirtual() && deployableDesc.isAssignableTo(deployedDesc.getDeployableType()) && containerDesc.isAssignableTo(deployedDesc.getContainerType());
            }
        }));
    }

    public Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        Type deployedType = this.findMostSpecificDeployedTypeForDeployableAndContainerTypes(deployable.getType(), container.getType());
        if (deployedType != null) {
            return this.generateDeployed(deployable, container, deployedType, dictionary);
        }
        return null;
    }

    public Deployed<?, ?> generateDeployed(Deployable deployable, Container container, Type deployedType, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> deployed = this.createDeployed(deployable, container, deployedType);
        this.setPropertyPlaceholders(deployed, deployable, dictionary);
        this.setFilePlaceholders(deployed, deployable, dictionary);
        return deployed;
    }

    private Deployed<Deployable, Container> createDeployed(Deployable deployable, Container container, Type deployedType) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed deployed = (Deployed)deployedDesc.newInstance();
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        IdGenerator.generateId((Deployed)deployed);
        return deployed;
    }

    private void setPropertyPlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        for (PropertyDescriptor deployedPropDesc : deployedDesc.getPropertyDescriptors()) {
            PropertyDescriptor deployablePropDesc;
            String name = deployedPropDesc.getName();
            if (name.equals("placeholders") || (deployablePropDesc = deployableDesc.getPropertyDescriptor(name)) == null) continue;
            Object value = deployablePropDesc.get((ConfigurationItem)deployable);
            if (value == null && dictionary.containsKey(deployedPropDesc.toString())) {
                value = dictionary.get(deployedPropDesc.toString());
                deployedPropDesc.set(deployed, value);
                continue;
            }
            try {
                value = dictionary.resolve(value);
                deployedPropDesc.set(deployed, value);
            }
            catch (DictionaryValueException exc) {
                logger.error("Could not resolve dictionary keys for property " + deployablePropDesc + " on " + deployed + ". Property will be left empty.", (Throwable)exc);
            }
            catch (RuntimeException exc) {
                logger.error("Could not convert (resolved) value to correct type for property " + deployablePropDesc + " on " + deployed + ". Property will be left empty.", (Throwable)exc);
            }
        }
    }

    private void setFilePlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        PropertyDescriptor deployedPlaceholdersDesc = deployedDesc.getPropertyDescriptor("placeholders");
        if (deployedPlaceholdersDesc != null) {
            PropertyDescriptor deployableplaceholders = deployableDesc.getPropertyDescriptor("placeholders");
            Set placeholders = (Set)deployableplaceholders.get((ConfigurationItem)deployable);
            deployedPlaceholdersDesc.set(deployed, this.resolveFilePlaceholders(Maps.newHashMap(), placeholders, dictionary));
        }
    }

    public Deployed<?, ?> generateUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Deployed<?, ?> upgradedDeployed = this.createUpgradedDeployed(newDeployable, existingDeployed);
        this.setUpgradedPropertyPlaceholders(upgradedDeployed, newDeployable, existingDeployed, dictionary);
        this.setUpgradedFilePlaceholders(upgradedDeployed, newDeployable, existingDeployed, dictionary);
        return upgradedDeployed;
    }

    private Deployed<?, ?> createUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed) {
        Type newDeployableType;
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)existingDeployed.getType());
        Type deployableType = deployedDesc.getDeployableType();
        Checks.checkArgument(deployableType.equals((Object)(newDeployableType = newDeployable.getType())) || DescriptorRegistry.getSubtypes((Type)deployableType).contains(newDeployableType), "The new Deployable type %s should be assignable to %s", newDeployableType, deployableType);
        Deployed upgradedDeployed = (Deployed)deployedDesc.newInstance();
        upgradedDeployed.setDeployable(newDeployable);
        upgradedDeployed.setId(existingDeployed.getId());
        return upgradedDeployed;
    }

    private void setUpgradedPropertyPlaceholders(Deployed<?, ?> upgradedDeployed, Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)existingDeployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployedDesc.getDeployableType());
        for (PropertyDescriptor deployedPropDesc : deployedDesc.getPropertyDescriptors()) {
            Object oldDeployedValue;
            String name = deployedPropDesc.getName();
            if (name.equals("placeholders") || name.equals("deployable")) continue;
            Object valueToSet = oldDeployedValue = deployedPropDesc.get(existingDeployed);
            PropertyDescriptor deployablePropDesc = deployableDesc.getPropertyDescriptor(name);
            if (deployablePropDesc != null) {
                Object oldDeployableValue = deployablePropDesc.get((ConfigurationItem)existingDeployed.getDeployable());
                if (oldDeployableValue != null && (oldDeployableValue.equals(oldDeployedValue) || MustachePlaceholderScanner.hasPlaceholders(oldDeployableValue.toString()))) {
                    valueToSet = deployablePropDesc.get((ConfigurationItem)newDeployable);
                }
                try {
                    valueToSet = dictionary.resolve(valueToSet);
                }
                catch (DictionaryValueException exc) {
                    valueToSet = oldDeployedValue;
                    logger.error("Could not resolve dictionary keys for property " + deployedPropDesc + " of " + upgradedDeployed + ". Property will be set to old value.", (Throwable)exc);
                }
            }
            try {
                deployedPropDesc.set(upgradedDeployed, valueToSet);
            }
            catch (RuntimeException exc) {
                logger.error("Could not convert (resolved) value to correct type for property " + deployedPropDesc + " of " + upgradedDeployed + ". Property will be left empty.", (Throwable)exc);
            }
        }
    }

    private void setUpgradedFilePlaceholders(Deployed<?, ?> upgradedDeployed, Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)upgradedDeployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)newDeployable.getType());
        PropertyDescriptor deployedPlaceholdersDesc = deployedDesc.getPropertyDescriptor("placeholders");
        if (deployedPlaceholdersDesc != null) {
            Map existingDeployedPlaceholders = (Map)deployedPlaceholdersDesc.get(existingDeployed);
            Set newDeployablePlaceholders = (Set)deployableDesc.getPropertyDescriptor("placeholders").get((ConfigurationItem)newDeployable);
            deployedPlaceholdersDesc.set(upgradedDeployed, this.resolveFilePlaceholders(existingDeployedPlaceholders, newDeployablePlaceholders, dictionary));
        }
    }

    private Map<String, String> resolveFilePlaceholders(Map<String, String> existingDeployedPlaceholders, Set<String> deployablePlaceholders, ConsolidatedDictionary dictionary) {
        HashMap newDeployedPlaceholders = Maps.newHashMap();
        for (String deployablePlaceholder : deployablePlaceholders) {
            String placeholderValue;
            try {
                placeholderValue = (String)dictionary.resolve("{{" + deployablePlaceholder + "}}");
            }
            catch (DictionaryValueException ignored) {
                placeholderValue = existingDeployedPlaceholders.containsKey(deployablePlaceholder) ? existingDeployedPlaceholders.get(deployablePlaceholder) : "";
            }
            newDeployedPlaceholders.put(deployablePlaceholder, placeholderValue);
        }
        return newDeployedPlaceholders;
    }
}

