/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.comparison;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component
public class Comparator {
    private static final String PASSWORD_OBFUSCATION = "********";

    public ListMultimap<String, String> compare(RepositoryObjectEntity reference, RepositoryObjectEntity ... entities) {
        ComputingLinkedMap comparison = new ComputingLinkedMap(entities.length + 1);
        this.checkCiTypes(reference.getType(), entities);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)reference.getType());
        int nrCi = 0;
        ArrayList entitiesToCompare = Lists.newArrayList();
        entitiesToCompare.add(reference);
        entitiesToCompare.addAll(Arrays.asList(entities));
        for (RepositoryObjectEntity compareEntity : entitiesToCompare) {
            this.writeFields(comparison, compareEntity, nrCi);
            this.writeProperties(comparison, compareEntity, descriptor, nrCi);
            ++nrCi;
        }
        LinkedListMultimap retval = LinkedListMultimap.create();
        for (String k : comparison.keySet()) {
            retval.putAll((Object)k, (Iterable)comparison.get(k));
        }
        return retval;
    }

    private void writeProperties(ComputingLinkedMap comparison, RepositoryObjectEntity entity, Descriptor descriptor, int nrCi) {
        Collection descriptors = descriptor.getPropertyDescriptors();
        block5: for (PropertyDescriptor propertyDescriptor : descriptors) {
            String key = propertyDescriptor.getName();
            Object value = entity.getValue(key);
            if (propertyDescriptor.isPassword()) {
                value = PASSWORD_OBFUSCATION;
            }
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case CI: {
                    comparison.put(key, (String)value, nrCi);
                    continue block5;
                }
                case SET_OF_STRING: 
                case SET_OF_CI: {
                    this.handleSetOfString(comparison, key, (Collection)value, nrCi);
                    continue block5;
                }
                case MAP_STRING_STRING: {
                    this.handleMap(comparison, key, (Map)value, nrCi);
                    continue block5;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void handleMap(ComputingLinkedMap comparison, String key, Map<String, String> value, int nrCi) {
        if (value != null) {
            TreeSet<String> set = new TreeSet<String>(value.keySet());
            for (String k : set) {
                comparison.put(key + ": " + k, value.get(k), nrCi);
            }
        }
    }

    private void handleSetOfString(ComputingLinkedMap comparison, String key, Collection<String> value, int nrCi) {
        if (value != null) {
            ArrayList<String> list = new ArrayList<String>(value);
            Collections.sort(list);
            comparison.put(key, Joiner.on((String)",").join(list), nrCi);
        }
    }

    private void writeFields(ComputingLinkedMap comparison, RepositoryObjectEntity entity, int nrCi) {
        comparison.put("id", entity.getId(), nrCi);
        comparison.put("type", entity.getType().toString(), nrCi);
    }

    private void checkCiTypes(Type referenceType, RepositoryObjectEntity ... entities) {
        for (RepositoryObjectEntity entity : entities) {
            Checks.checkArgument(entity.getType().equals((Object)referenceType), "Not all configuration items are of type %s", referenceType);
        }
    }

    static class ComputingLinkedMap
    extends LinkedHashMap<String, List<String>> {
        private final int listSize;
        private String[] strings;

        public ComputingLinkedMap(int listSize) {
            this.listSize = listSize;
            this.strings = new String[listSize];
            Arrays.fill(this.strings, "");
        }

        @Override
        public List<String> get(Object o) {
            List value = (List)super.get(o);
            if (value == null) {
                value = Lists.newArrayList((Object[])this.strings);
                super.put((String)o, value);
            }
            return value;
        }

        public void put(String key, String value, int position) {
            Object values = this.get(key);
            values.remove(position);
            values.add(position, value);
        }
    }
}

