/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.EntityNodeReader;
import com.xebialabs.deployit.repository.EntityNodeWriter;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JcrRepositoryService
implements RepositoryService {
    private JcrTemplate jcrTemplate;

    @Autowired
    public JcrRepositoryService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public void execute(ChangeSet changeset) {
        this.jcrTemplate.execute(new ChangeSetExecutor(changeset));
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new ReferentialIntegrityChecker(changeset));
    }

    @Override
    public <T extends RepositoryObjectEntity> void create(T ... entities) {
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateEntities(Lists.newArrayList((Object[])entities));
        this.execute(changeset);
    }

    @Override
    public <T extends RepositoryObjectEntity> T read(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return this.read(id, false);
    }

    @Override
    public <T extends RepositoryObjectEntity> T readFully(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return this.read(id, true);
    }

    private <T extends RepositoryObjectEntity> T read(final String id, final boolean fully) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (T)((RepositoryObjectEntity)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    return new EntityNodeReader(session, node, fully).getEntity();
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException(exc, "Repository entity [%s] not found", id);
                }
            }
        }));
    }

    @Override
    public <T extends RepositoryObjectEntity> void update(T ... entities) {
        ChangeSet changeset = new ChangeSet();
        changeset.setUpdateEntities(Lists.newArrayList((Object[])entities));
        this.execute(changeset);
    }

    @Override
    public void delete(String ... ids) {
        ChangeSet changeset = new ChangeSet();
        changeset.setDeleteEntityIds(Lists.newArrayList((Object[])ids));
        this.execute(changeset);
    }

    @Override
    public List<String> list(SearchParameters parameters) {
        Preconditions.checkNotNull((Object)parameters);
        List entities = this.listEntities(parameters);
        ArrayList entityIds = Lists.newArrayList();
        for (RepositoryObjectEntity each : entities) {
            entityIds.add(each.getId());
        }
        return entityIds;
    }

    @Override
    public <T extends RepositoryObjectEntity> List<T> listEntities(final SearchParameters parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null");
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                Query query = new SearchQueryBuilder(parameters).build(session);
                QueryResult queryResult = query.execute();
                if (parameters.at != null) {
                    return JcrRepositoryService.this.getDistinctEntities(parameters, session, queryResult);
                }
                return JcrRepositoryService.this.getOrderedEntities(parameters, session, queryResult);
            }
        });
    }

    private <T extends RepositoryObjectEntity> List<T> getDistinctEntities(SearchParameters parameters, Session session, QueryResult queryResult) throws RepositoryException, IOException {
        LinkedHashMap entities = new LinkedHashMap();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                Node each = iterator.nextRow().getNode("ci");
                Object entity = new EntityNodeReader(session, each, false).getEntity();
                if (!this.entityNotFoundYetOrNewerThenEntityAlreadyFound(entities, entity)) continue;
                entities.put(((RepositoryObjectEntity)entity).getId(), entity);
            }
            catch (RepositoryException rre) {}
        }
        return new ArrayList(entities.values());
    }

    private <T extends RepositoryObjectEntity> boolean entityNotFoundYetOrNewerThenEntityAlreadyFound(Map<String, T> entities, T entity) {
        return !entities.containsKey(entity.getId()) || ((RepositoryObjectEntity)entities.get(entity.getId())).getLastModified().before(entity.getLastModified());
    }

    private <T extends RepositoryObjectEntity> List<T> getOrderedEntities(SearchParameters parameters, Session session, QueryResult queryResult) throws RepositoryException, IOException {
        ArrayList entities = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                Node each = iterator.nextRow().getNode("ci");
                entities.add(new EntityNodeReader(session, each, false).getEntity());
            }
            catch (RepositoryException rre) {}
        }
        if (parameters.after != null || parameters.before != null) {
            Collections.sort(entities, new Comparator<T>(){

                @Override
                public int compare(T lhs, T rhs) {
                    int diff = ((RepositoryObjectEntity)lhs).getId().compareTo(((RepositoryObjectEntity)rhs).getId());
                    if (diff != 0) {
                        return diff;
                    }
                    return ((RepositoryObjectEntity)lhs).getLastModified().compareTo(((RepositoryObjectEntity)rhs).getLastModified());
                }
            });
        }
        return entities;
    }

    @Override
    public boolean checkNodeExists(final String id) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(id));
            }
        });
    }

    static String generateJcrPropertyNameForNestedProperty(PropertyDescriptor pd, PropertyDescriptor nestedPd) {
        return pd.getName() + "_" + nestedPd.getName();
    }

    private static class PropertyRef {
        private String owningNode;
        private String property;
        private String uuidOfReferencedNode;

        PropertyRef(String owningNode, String property, String uuidOfReferencedNode) {
            this.owningNode = owningNode;
            this.property = property;
            this.uuidOfReferencedNode = uuidOfReferencedNode;
        }
    }

    private static class ReferentialIntegrityChecker
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ReferentialIntegrityChecker(ChangeSet changeset) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(session);
            Multimap<String, PropertyRef> deletedEntityRefs = this.findReferencesToDeletedNodes(session);
            ChangeSetExecutor changeSetExecutor = new ChangeSetExecutor(this.changeset);
            changeSetExecutor.execute(session, false);
            try {
                this.checkForRemainingReferencesToDeletedNodes(deletedEntityRefs, session);
            }
            finally {
                session.refresh(false);
            }
            return null;
        }

        private void checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(Session session) throws RepositoryException {
            for (RepositoryObjectEntity entity : this.changeset.getCreateEntities()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(entity.getId()))) continue;
                throw new ItemAlreadyExistsException("Repository entity %s already exists", entity.getId());
            }
        }

        private Multimap<String, PropertyRef> findReferencesToDeletedNodes(Session session) throws RepositoryException {
            ArrayListMultimap deletedEntityRefs = ArrayListMultimap.create();
            for (String deleteNodeId : this.changeset.getDeleteEntityIds()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(deleteNodeId))) continue;
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(deleteNodeId));
                PropertyIterator references = node.getReferences();
                while (references.hasNext()) {
                    Property property = references.nextProperty();
                    Node parent = property.getParent();
                    deletedEntityRefs.put((Object)deleteNodeId, (Object)new PropertyRef(parent.getPath(), property.getName(), node.getIdentifier()));
                }
            }
            return deletedEntityRefs;
        }

        private void checkForRemainingReferencesToDeletedNodes(Multimap<String, PropertyRef> deletedEntityRefs, Session session) throws RepositoryException {
            for (String deleteNodeId : deletedEntityRefs.keySet()) {
                for (PropertyRef propertyRef : deletedEntityRefs.get((Object)deleteNodeId)) {
                    Value[] values;
                    Value[] valueArray;
                    Node owningNode;
                    if (!session.nodeExists(propertyRef.owningNode) || !(owningNode = session.getNode(propertyRef.owningNode)).hasProperty(propertyRef.property)) continue;
                    Property property = owningNode.getProperty(propertyRef.property);
                    if (property.isMultiple()) {
                        valueArray = property.getValues();
                    } else {
                        Value[] valueArray2 = new Value[1];
                        valueArray = valueArray2;
                        valueArray2[0] = property.getValue();
                    }
                    for (Value value : values = valueArray) {
                        if (!value.getString().equals(propertyRef.uuidOfReferencedNode)) continue;
                        throw new ItemInUseException("Repository entity %s is still referenced by %s", deleteNodeId, propertyRef.owningNode);
                    }
                }
            }
        }
    }

    private static class EntitiesSortHierarchyComparator
    implements Comparator<RepositoryObjectEntity> {
        private EntitiesSortHierarchyComparator() {
        }

        @Override
        public int compare(RepositoryObjectEntity o1, RepositoryObjectEntity o2) {
            int nrSlashes1 = StringUtils.countOccurrencesOf((String)o1.getId(), (String)"/");
            int nrSlashes2 = StringUtils.countOccurrencesOf((String)o2.getId(), (String)"/");
            return nrSlashes1 - nrSlashes2;
        }
    }

    private static class ChangeSetExecutor
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ChangeSetExecutor(ChangeSet changeset) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
        }

        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.execute(session, true);
            return null;
        }

        public void execute(Session session, boolean autocommit) throws RepositoryException {
            try {
                this.createEntities(this.changeset.getCreateEntities(), session);
                this.updateEntities(this.changeset.getUpdateEntities(), session);
                this.deleteEntities(this.changeset.getDeleteEntityIds(), session);
                if (autocommit) {
                    session.save();
                }
            }
            catch (ReferentialIntegrityException exc) {
                throw new ItemInUseException(exc, "Cannot delete configuration items [%s] because one of the configuration items, or one of their children, is still being referenced", Joiner.on((char)',').join(this.changeset.getDeleteEntityIds()));
            }
        }

        private void createEntities(List<RepositoryObjectEntity> entities, Session session) throws RepositoryException {
            this.verifyEntitiesMeetCreationPreconditions(entities);
            Collections.sort(entities, new EntitiesSortHierarchyComparator());
            ArrayList writers = Lists.newArrayList();
            for (RepositoryObjectEntity entity : entities) {
                Node node = this.createNode(entity, session);
                EntityNodeWriter nodeWriter = new EntityNodeWriter(session, entity, node);
                nodeWriter.writeBasics();
                writers.add(nodeWriter);
            }
            this.writeEntities(writers);
        }

        private void updateEntities(List<RepositoryObjectEntity> entities, Session session) throws RepositoryException {
            List<Node> nodes = this.retrieveAndCheckpointNodesToBeUpdated(entities, session);
            for (int i = 0; i < entities.size(); ++i) {
                this.updateNode(entities.get(i), nodes.get(i), session);
            }
        }

        private void deleteEntities(List<String> entityIds, Session session) throws RepositoryException {
            List<Node> nodes = this.retrieveAndCheckpointNodesToBeDeleted(entityIds, session);
            for (Node node : nodes) {
                this.deleteNode(node);
            }
        }

        private List<Node> retrieveAndCheckpointNodesToBeUpdated(List<RepositoryObjectEntity> entities, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (RepositoryObjectEntity entity : entities) {
                Preconditions.checkNotNull((Object)entity, (Object)"entity is null");
                Preconditions.checkNotNull((Object)entity.getId(), (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(entity.getId()));
                    this.checkpoint(node, session);
                    nodes.add(node);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", entity.getId());
                }
            }
            return nodes;
        }

        private List<Node> retrieveAndCheckpointNodesToBeDeleted(List<String> ids, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (String id : ids) {
                Preconditions.checkNotNull((Object)id, (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    this.checkpoint(node, session);
                    nodes.add(node);
                }
                catch (PathNotFoundException ignored) {}
            }
            return nodes;
        }

        private Node createNode(RepositoryObjectEntity entity, Session session) throws RepositoryException {
            this.validateNodeStoredInCorrectPath(entity, session);
            Node node = session.getRootNode().addNode(entity.getId());
            int index = node.getIndex();
            if (index != 1) {
                node.remove();
                throw new ItemAlreadyExistsException("Repository entity with ID [%s] already exists", entity.getId());
            }
            this.setMixins(entity, node);
            return node;
        }

        private void updateNode(RepositoryObjectEntity entity, Node node, Session session) throws RepositoryException {
            new EntityNodeWriter(session, entity, node).write();
        }

        private void deleteNode(Node node) throws RepositoryException {
            node.remove();
        }

        private void checkpoint(Node node, Session session) throws RepositoryException {
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkpoint(node.getPath());
        }

        private void verifyEntitiesMeetCreationPreconditions(List<RepositoryObjectEntity> entities) {
            for (int i = 0; i < entities.size(); ++i) {
                RepositoryObjectEntity entity = entities.get(i);
                Preconditions.checkNotNull((Object)entity, (String)"entity at index %s is null.", (Object[])new Object[]{i});
                Preconditions.checkNotNull((Object)entity.getId(), (String)"entity at index %s has null id.", (Object[])new Object[]{i});
                if (!(entity instanceof ArtifactEntity)) continue;
                Preconditions.checkArgument((((ArtifactEntity)entity).getFilename() != null ? 1 : 0) != 0, (String)"Artifact %s should have filename", (Object[])new Object[]{entity.getId()});
                Preconditions.checkArgument((boolean)((ArtifactEntity)entity).containsData(), (String)"Artifact %s should contain data", (Object[])new Object[]{entity.getId()});
            }
        }

        private void validateNodeStoredInCorrectPath(RepositoryObjectEntity entity, Session session) throws RepositoryException {
            String id = entity.getId();
            Type type = entity.getType();
            Descriptor desc = DescriptorRegistry.getDescriptor((Type)type);
            Preconditions.checkNotNull((Object)desc, (String)"Unknown configuration item type %s", (Object[])new Object[]{type});
            String[] pathElements = id.split("/");
            if (desc.getRoot() == Metadata.ConfigurationItemRoot.NESTED) {
                Checks.checkArgument(pathElements.length >= 3, "Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", type, id);
                String parentId = id.substring(0, id.lastIndexOf(47));
                Node parentNode = session.getNode(JcrPathHelper.getAbsolutePathFromId(parentId));
                Checks.checkArgument(parentNode != null, "Configuration item of type %s cannot be stored at %s. The parent does not exist", type, id);
                Checks.checkArgument(parentNode.isNodeType("deployit:configurationItem"), "Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", type, id);
                String parentTypeName = parentNode.getProperty("$configuration.item.type").getString();
                Descriptor parentDescriptor = DescriptorRegistry.getDescriptor((String)parentTypeName);
                for (PropertyDescriptor aPD : desc.getPropertyDescriptors()) {
                    if (aPD.getKind() != PropertyKind.CI || !aPD.isAsContainment() || !this.matchesType(parentDescriptor, aPD.getReferencedType())) continue;
                    return;
                }
                for (PropertyDescriptor aPD : parentDescriptor.getPropertyDescriptors()) {
                    if (aPD.getKind() != PropertyKind.SET_OF_CI || !aPD.isAsContainment() || !this.matchesType(desc, aPD.getReferencedType())) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", type, id);
            }
            Checks.checkArgument(pathElements.length == 2 && pathElements[0].equals(desc.getRoot().getRootNodeName()), "Configuration item of type %s cannot be stored at %s. It should be stored under %s", type, id, desc.getRoot().getRootNodeName());
        }

        private boolean matchesType(Descriptor desc, Type wantedType) {
            return desc.getType().equals((Object)wantedType) || DescriptorRegistry.getSubtypes((Type)wantedType).contains(desc.getType());
        }

        private void setMixins(RepositoryObjectEntity entity, Node node) throws RepositoryException {
            if (entity instanceof ArtifactEntity) {
                node.addMixin("deployit:artifact");
                node.addMixin("deployit:configurationItem");
            } else if (entity instanceof ConfigurationItemEntity) {
                node.addMixin("deployit:configurationItem");
            } else {
                throw new IllegalArgumentException("Not supporting RepositoryEntity type " + entity.getClass().getName());
            }
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }

        private void writeEntities(List<EntityNodeWriter> writers) throws RepositoryException {
            for (EntityNodeWriter writer : writers) {
                writer.write();
            }
        }
    }
}

