/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;

class EntityNodeWriter {
    private final Session session;
    private final RepositoryObjectEntity entity;
    private final Node node;
    private boolean basicsWritten = false;

    public EntityNodeWriter(Session session, RepositoryObjectEntity entity, Node node) {
        this.session = session;
        this.entity = entity;
        this.node = node;
    }

    public void writeBasics() throws RepositoryException {
        this.copyConfigurationItemTypeName();
        this.basicsWritten = true;
    }

    public void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
    }

    private void copyConfigurationItemTypeName() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.entity.getType().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyData() throws RepositoryException {
        if (this.entity instanceof ArtifactEntity) {
            ArtifactEntity artifact = (ArtifactEntity)this.entity;
            if (artifact.getFilename() != null) {
                this.node.setProperty("$filename", artifact.getFilename());
            }
            if (artifact.containsData()) {
                try {
                    InputStream dataInput = (InputStream)artifact.getData().getInput();
                    try {
                        Binary binary = this.session.getValueFactory().createBinary(dataInput);
                        this.node.setProperty("$data", binary);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)dataInput);
                    }
                }
                catch (IOException exc) {
                    throw new RepositoryException("Cannot read artifact data for " + artifact, (Throwable)exc);
                }
            }
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor ciDescriptor = DescriptorRegistry.getDescriptor((Type)this.entity.getType());
        block7: for (PropertyDescriptor pd : ciDescriptor.getPropertyDescriptors()) {
            if (this.entity.getValue(pd.getName()) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            if (pd.isHidden()) continue;
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block7;
                }
                case SET_OF_STRING: {
                    this.copySetOfStringsPropertyIntoNode(pd);
                    continue block7;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block7;
                }
                case SET_OF_CI: {
                    this.copySetOfConfigurationItemsPropertyIntoNode(pd);
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(pd);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        Map value = (Map)this.entity.getValue(pd.getName());
        ArrayList valueList = Lists.newArrayList();
        for (String s : value.keySet()) {
            Value v = this.session.getValueFactory().createValue(s + "=" + (String)value.get(s));
            valueList.add(v);
        }
        Value[] jcrValues = valueList.toArray(new Value[valueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyMetadata() throws RepositoryException {
        this.node.setProperty("$id", this.entity.getId());
        if (this.entity.getOverrideLastModified() != null) {
            this.node.setProperty("$lastModified", this.entity.getOverrideLastModified());
        } else {
            this.node.setProperty("$lastModified", Calendar.getInstance());
        }
        if (this.entity.getCreatingTaskId() != null) {
            this.node.setProperty("$creatingTaskId", this.entity.getCreatingTaskId());
        }
    }

    private void removePropertyFromNode(PropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = this.convertObjectValueToString(pd, this.entity.getValue(pd.getName()));
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copySetOfStringsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, this.entity.getValue(pd.getName()));
        ArrayList jcrValueList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof String)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.entity.getId() + " is not a String: " + each);
            }
            String stringValue = (String)each;
            jcrValueList.add(valueFactory.createValue(stringValue));
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        String referencedCiId = this.convertObjectValueToString(pd, this.entity.getValue(pd.getName()));
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copySetOfConfigurationItemsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, this.entity.getValue(pd.getName()));
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof String)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.entity.getId() + " is not a String: " + each);
            }
            String referencedCiId = (String)each;
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            jcrReferenceList.add(new ReferenceValue(referencedCi));
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        this.node.setProperty(pd.getName(), jcrReferenceValues);
    }

    private String convertObjectValueToString(PropertyDescriptor pd, Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.entity.getId() + " is not a String: " + value);
        }
        return (String)value;
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.entity.getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }
}

