/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.Exploder;
import com.xebialabs.deployit.plugin.Imploder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FileArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class PojoConverter
implements InitializingBean {
    public static final OverthereFile NO_ARTIFACT_DATA_LOCATION = LocalFile.valueOf((File)new File("no-artifact-data"));
    private final RepositoryService repositoryService;
    private File workDir;
    private static final Logger logger = LoggerFactory.getLogger(PojoConverter.class);

    @Autowired
    public PojoConverter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void afterPropertiesSet() {
        if (!this.workDir.mkdirs() && !this.workDir.exists()) {
            throw new RuntimeIOException("Cannot create work dir " + this.workDir);
        }
    }

    public Context getContext() {
        return new Context();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ConfigurationItem> ConfigurationItemEntity toEntity(T pojo) {
        Context context = new Context();
        try {
            ConfigurationItemEntity configurationItemEntity = context.toEntity(pojo);
            return configurationItemEntity;
        }
        finally {
            context.destroy();
        }
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public class Context {
        private Map<String, ConfigurationItemEntity> entitiesQueuedForConversion = Maps.newHashMap();
        private List<File> artifactDataWorkDirs = Lists.newArrayList();
        private Map<String, ConfigurationItem> convertedPojos = Maps.newHashMap();

        private Context() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <F extends ConfigurationItemEntity, G> Collection<G> toPojo(Collection<F> entities) {
            for (ConfigurationItemEntity entity : entities) {
                this.entitiesQueuedForConversion.put(entity.getId(), entity);
            }
            try {
                ArrayList result = Lists.newArrayList();
                for (ConfigurationItemEntity entity : entities) {
                    result.add(this.toPojo(entity));
                }
                ArrayList arrayList = result;
                return arrayList;
            }
            finally {
                this.entitiesQueuedForConversion.clear();
            }
        }

        private ConfigurationItem newPojoInstance(ConfigurationItemEntity item) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            ConfigurationItem pojo = descriptor.newInstance();
            this.fillId(pojo, item);
            return pojo;
        }

        public <T> T toPojo(ConfigurationItemEntity item) {
            if (this.convertedPojos.containsKey(item.getId())) {
                logger.debug("Returning previously generated POJO for configuration item {}", (Object)item.getId());
                return (T)this.convertedPojos.get(item.getId());
            }
            logger.debug("Reading {}", (Object)item.getId());
            ConfigurationItem pojo = this.newPojoInstance(item);
            this.storeReferenceToPojo(pojo);
            this.fillFields(pojo, item, DescriptorRegistry.getDescriptor((Type)item.getType()));
            if (item instanceof ArtifactEntity) {
                this.initSourceArtifact(pojo, (ArtifactEntity)item);
            }
            if (pojo instanceof DerivedArtifact) {
                this.initDerivedArtifact((DerivedArtifact<? extends SourceArtifact>)((DerivedArtifact)pojo));
            }
            return (T)pojo;
        }

        private void storeReferenceToPojo(ConfigurationItem pojo) {
            this.convertedPojos.put(pojo.getId(), pojo);
        }

        private void fillId(ConfigurationItem pojo, ConfigurationItemEntity item) {
            pojo.setId(item.getId());
        }

        private void fillFields(ConfigurationItem pojo, RepositoryObjectEntity item, Descriptor descriptor) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                this.fillProperty(pojo, item, propertyDescriptor);
            }
        }

        private void fillProperty(ConfigurationItem pojo, RepositoryObjectEntity entity, PropertyDescriptor propertyDescriptor) {
            String propertyName = propertyDescriptor.getName();
            Object itemValue = entity.getValue(propertyName);
            this.setPropertyInPojo(pojo, itemValue, propertyDescriptor);
        }

        private <T extends ConfigurationItem> void setPropertyInPojo(T pojo, Object pojoValue, PropertyDescriptor propertyDescriptor) {
            if (pojoValue == null) {
                return;
            }
            logger.debug("Loading {} of {} with value {}", new Object[]{propertyDescriptor.getName(), pojo, pojoValue});
            Object value = this.convertValueForPojo(pojoValue, propertyDescriptor);
            propertyDescriptor.set(pojo, value);
        }

        private Object convertValueForPojo(Object pojoValue, PropertyDescriptor propertyDescriptor) {
            Object value;
            switch (propertyDescriptor.getKind()) {
                case STRING: {
                    if (propertyDescriptor.isPassword()) {
                        value = PasswordObfuscator.decrypt(pojoValue.toString());
                        break;
                    }
                }
                case BOOLEAN: 
                case INTEGER: 
                case ENUM: {
                    value = pojoValue;
                    break;
                }
                case SET_OF_STRING: {
                    value = this.handleSetOfString(pojoValue);
                    break;
                }
                case CI: {
                    value = this.handleConfigurationItem((String)((Object)pojoValue));
                    break;
                }
                case SET_OF_CI: {
                    value = this.handleSetofConfigurationItems((Collection<String>)pojoValue);
                    break;
                }
                case MAP_STRING_STRING: {
                    value = pojoValue != null ? Maps.newHashMap((Map)((Map)((Object)pojoValue))) : null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should not end up here!");
                }
            }
            return value;
        }

        private Set<String> handleSetOfString(Object pojoValue) {
            if (pojoValue instanceof Set) {
                return (Set)pojoValue;
            }
            if (pojoValue instanceof Collection) {
                return Sets.newHashSet((Iterable)((Collection)pojoValue));
            }
            throw new IllegalStateException("Did not get a Set of String or other Collection type.");
        }

        private Object handleSetofConfigurationItems(Collection<String> ids) {
            HashSet result = Sets.newHashSet();
            for (String id : ids) {
                result.add(this.handleConfigurationItem(id));
            }
            return result;
        }

        private Object handleConfigurationItem(String id) {
            if (this.convertedPojos.containsKey(id)) {
                return this.convertedPojos.get(id);
            }
            ConfigurationItemEntity ci = this.entitiesQueuedForConversion.containsKey(id) ? this.entitiesQueuedForConversion.get(id) : (ConfigurationItemEntity)PojoConverter.this.repositoryService.readFully(id);
            return this.toPojo(ci);
        }

        private void initSourceArtifact(ConfigurationItem o, ArtifactEntity item) {
            if (item.getData() == null) {
                logger.warn("Not filling in the artifact data, because it wasn't set.");
                return;
            }
            if (o instanceof FolderArtifact) {
                FolderArtifact da = (FolderArtifact)o;
                da.setFile(LocalFile.valueOf((File)this.writeArtifactDataToWorkFolder(item)));
            } else if (o instanceof FileArtifact) {
                FileArtifact da = (FileArtifact)o;
                da.setFile(LocalFile.valueOf((File)this.writeArtifactDataToWorkFile(item)));
            } else {
                throw new IllegalArgumentException("Unknown subclass of " + Artifact.class + ": " + o.getClass());
            }
        }

        private void initDerivedArtifact(DerivedArtifact<? extends SourceArtifact> da) {
            if (da.getSourceArtifact() != null) {
                da.initFile(new PlaceholderReplacer(){

                    public void replace(Reader in, Writer out, Map<String, String> resolution) {
                        new MustachePlaceholderReplacer(resolution).replace(in, out);
                    }
                });
                if (da.getFile() == null) {
                    this.convertedPojos.remove(da.getId());
                    throw new Checks.IncorrectArgumentException("After initialization DeployedArtifact %s has not set a file, cannot deploy.", da.getId());
                }
            }
        }

        private File writeArtifactDataToWorkFile(ArtifactEntity item) {
            try {
                logger.debug("Writing data for artifact {} to temporary file in work directory {}", (Object)item.getId(), (Object)PojoConverter.this.workDir);
                final File artifactDataWorkFile = this.getArtifactDataWorkFile(item);
                ByteStreams.copy(item.getData(), (OutputSupplier)new OutputSupplier<OutputStream>(){

                    public OutputStream getOutput() throws IOException {
                        return new FileOutputStream(artifactDataWorkFile);
                    }
                });
                logger.debug("Wrote data for artifact {} to file {} in work directory", (Object)item.getId(), (Object)artifactDataWorkFile);
                return artifactDataWorkFile;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot write artifact data to temporary file for artifact " + item.getId(), exc);
            }
        }

        private File writeArtifactDataToWorkFolder(ArtifactEntity item) {
            try {
                logger.debug("Exploding folder artifact {} to temporary directory work directory {}", (Object)item.getId(), (Object)PojoConverter.this.workDir);
                File artifactDataWorkDir = this.getArtifactDataWorkFile(item);
                Exploder.explode(item.getData(), artifactDataWorkDir);
                logger.debug("Exploded folder artifact {} to directory {} in work directory", (Object)item.getId(), (Object)artifactDataWorkDir);
                return artifactDataWorkDir;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot write artifact data to temporary folder for artifact " + item.getId(), exc);
            }
        }

        private File getArtifactDataWorkFile(ArtifactEntity item) throws IOException {
            String baseDirName = item.getId().replace('/', '_');
            Random r = new Random();
            for (int tries = 0; tries < 100; ++tries) {
                File artifactDataWorkDir = new File(PojoConverter.this.workDir, baseDirName + Math.abs(r.nextLong()));
                if (artifactDataWorkDir.exists()) continue;
                if (!artifactDataWorkDir.mkdir()) {
                    throw new IOException("Cannot create directory " + artifactDataWorkDir);
                }
                this.artifactDataWorkDirs.add(artifactDataWorkDir);
                return new File(artifactDataWorkDir, item.getFilename());
            }
            throw new IllegalStateException("Cannot generate work dir for " + item);
        }

        public void destroy() {
            this.deleteArtifactDataWorkDirs();
            this.setArtifactFileToPointToNonExistentFile();
        }

        private void deleteArtifactDataWorkDirs() {
            for (File d : this.artifactDataWorkDirs) {
                try {
                    GuavaFiles.deleteRecursively(d);
                }
                catch (IOException exc) {
                    logger.warn("Cannot delete artifact data work dir " + d, (Throwable)exc);
                }
            }
            this.artifactDataWorkDirs.clear();
        }

        private void setArtifactFileToPointToNonExistentFile() {
            for (ConfigurationItem pojo : this.convertedPojos.values()) {
                if (!(pojo instanceof Artifact)) continue;
                ((Artifact)pojo).setFile(NO_ARTIFACT_DATA_LOCATION);
            }
            this.convertedPojos.clear();
        }

        public <T extends ConfigurationItem> ConfigurationItemEntity toEntity(T pojo) {
            ConfigurationItemEntity entity = pojo instanceof SourceArtifact ? new ArtifactEntity(pojo.getType()) : new ConfigurationItemEntity(pojo.getType());
            entity.setId(pojo.getId());
            this.setProperties(pojo, entity);
            if (pojo instanceof SourceArtifact) {
                this.setData((SourceArtifact)pojo, (ArtifactEntity)entity);
            }
            return entity;
        }

        public <F extends ConfigurationItem, G extends ConfigurationItemEntity> List<G> toEntity(List<F> pojos) {
            ArrayList entities = Lists.newArrayList();
            for (ConfigurationItem each : pojos) {
                entities.add(this.toEntity(each));
            }
            return entities;
        }

        private <T extends ConfigurationItem> void setProperties(T item, ConfigurationItemEntity entity) {
            for (PropertyDescriptor each : DescriptorRegistry.getDescriptor((Type)entity.getType()).getPropertyDescriptors()) {
                this.putProperty(item, entity, each);
            }
        }

        private <T extends ConfigurationItem> void putProperty(T item, ConfigurationItemEntity entity, PropertyDescriptor propertyDescriptor) {
            Object valueForEntity = this.getValueFromPojo(item, propertyDescriptor);
            if (valueForEntity != null) {
                entity.addValue(propertyDescriptor.getName(), valueForEntity);
            }
        }

        private <T extends ConfigurationItem> Object getValueFromPojo(T pojo, PropertyDescriptor propertyDescriptor) {
            Object valueFromPojo = propertyDescriptor.get(pojo);
            return this.convertValueForEntity(propertyDescriptor, valueFromPojo);
        }

        private Object convertValueForEntity(PropertyDescriptor propertyDescriptor, Object valueFromPojo) {
            Object valueForEntity = null;
            switch (propertyDescriptor.getKind()) {
                case STRING: {
                    if (valueFromPojo != null && propertyDescriptor.isPassword()) {
                        valueForEntity = PasswordObfuscator.ensureEncrypted(valueFromPojo.toString());
                        break;
                    }
                }
                case BOOLEAN: 
                case INTEGER: 
                case ENUM: {
                    if (valueFromPojo == null) break;
                    valueForEntity = valueFromPojo.toString();
                    break;
                }
                case SET_OF_STRING: {
                    valueForEntity = valueFromPojo;
                    break;
                }
                case CI: {
                    if (valueFromPojo == null) break;
                    valueForEntity = ((ConfigurationItem)valueFromPojo).getId();
                    break;
                }
                case SET_OF_CI: {
                    Set referencedCis = (Set)valueFromPojo;
                    HashSet result = Sets.newHashSet();
                    if (referencedCis != null) {
                        for (Object each : referencedCis) {
                            result.add(((ConfigurationItem)each).getId());
                        }
                    }
                    valueForEntity = result;
                    break;
                }
                case MAP_STRING_STRING: {
                    Map map = (Map)valueFromPojo;
                    if (map != null) {
                        return Maps.newHashMap((Map)map);
                    }
                    return null;
                }
                default: {
                    throw new IllegalStateException("Should not end up here!");
                }
            }
            return valueForEntity;
        }

        private <T extends SourceArtifact> void setData(T pojo, ArtifactEntity entity) {
            if (pojo.getFile() == null) {
                return;
            }
            entity.setFilename(pojo.getFile().getName());
            if (pojo instanceof FolderArtifact) {
                this.setFolderData((FolderArtifact)pojo, entity);
            } else if (pojo instanceof FileArtifact) {
                this.setFileData((FileArtifact)pojo, entity);
            } else {
                throw new IllegalArgumentException("Unknown subclass of " + SourceArtifact.class + ": " + pojo.getClass());
            }
        }

        private <T extends FolderArtifact> void setFolderData(T item, ArtifactEntity entity) {
            try {
                OverthereFile file = item.getFile();
                byte[] implodedFolderData = Imploder.implode(((LocalFile)file).getFile());
                entity.setData((InputSupplier<? extends InputStream>)ByteStreams.newInputStreamSupplier((byte[])implodedFolderData));
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot read artifact folder data from " + item, exc);
            }
        }

        private <T extends FileArtifact> void setFileData(final T item, ArtifactEntity entity) {
            entity.setData((InputSupplier<? extends InputStream>)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return item.getFile().getInputStream();
                }
            });
        }
    }
}

