/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialDeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;
    private final transient PojoConverter pojoConverter;
    private Logger logger = LoggerFactory.getLogger(InitialDeploymentTask.class);

    public InitialDeploymentTask(DeltaSpecification specification, List<? extends DeploymentStep> steps, RepositoryService repositoryService, PojoConverter pojoConverter, PojoConverter.Context ... pojoConverterContexts) {
        super(steps, repositoryService, pojoConverterContexts);
        this.specification = specification;
        this.pojoConverter = pojoConverter;
        this.initFromDeployment(specification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doAs() {
                PojoConverter.Context context = InitialDeploymentTask.this.pojoConverter.getContext();
                try {
                    InitialDeploymentTask.this.repositoryService.checkReferentialIntegrity(InitialDeploymentTask.this.determineRepositoryChanges(context));
                }
                finally {
                    context.destroy();
                }
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges(PojoConverter.Context context) {
        DeployedApplication newDeployment = this.specification.getDeployedApplication();
        ArrayList roes = Lists.newArrayList();
        for (Delta operation : this.specification.getDeltas()) {
            Deployed deployed = operation.getDeployed();
            roes.add(context.toEntity(deployed));
            newDeployment.addDeployed(deployed);
        }
        ConfigurationItemEntity updatedNewDeploymentEntity = context.toEntity(newDeployment);
        updatedNewDeploymentEntity.setCreatingTaskId(this.getId());
        roes.add(updatedNewDeploymentEntity);
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateEntities(roes);
        return changeset;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        UsernameAndPasswordCredentials owner = this.getOwnerCredentials();
        SecurityTemplate.executeAs(owner.getUsername(), owner.getPassword(), new SecurityCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doAs() {
                PojoConverter.Context context = InitialDeploymentTask.this.pojoConverter.getContext();
                try {
                    InitialDeploymentTask.this.repositoryService.execute(InitialDeploymentTask.this.determineRepositoryChanges(context));
                }
                finally {
                    context.destroy();
                }
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.INITIAL;
    }
}

