/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.task.StepList;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import java.util.List;

public abstract class DeploymentTask
extends Task {
    protected final transient RepositoryService repositoryService;
    protected final transient PojoConverter.Context[] pojoConverterContextsToDestroy;
    private String applicationName;
    private String applicationVersion;
    private String environment;

    public DeploymentTask(List<? extends DeploymentStep> steps, RepositoryService repositoryService, PojoConverter.Context ... pojoConverterContextsToDestroy) {
        super(steps);
        this.repositoryService = repositoryService;
        this.pojoConverterContextsToDestroy = pojoConverterContextsToDestroy;
    }

    DeploymentTask(List<? extends DeploymentStep> steps) {
        super(steps);
        this.repositoryService = null;
        this.pojoConverterContextsToDestroy = null;
    }

    protected DeploymentTask(List<TaskStep> steps, Task.State state) {
        this(new StepList(steps, steps.size()), state);
    }

    DeploymentTask(StepList stepList, Task.State state) {
        super(stepList, state);
        this.repositoryService = null;
        this.pojoConverterContextsToDestroy = null;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.pojoConverterContextsToDestroy == null) {
            return;
        }
        for (PojoConverter.Context each : this.pojoConverterContextsToDestroy) {
            each.destroy();
        }
    }

    protected void initFromDeployment(DeployedApplication deployment) {
        this.setApplicationName(deployment.getVersion().getApplication().getName());
        this.setApplicationVersion(deployment.getVersion().getVersion());
        this.setEnvironment(deployment.getEnvironment().getName());
    }

    private String findLastPathElement(String path) {
        int lastIndexOf = path.lastIndexOf("/");
        if (lastIndexOf > -1) {
            return path.substring(lastIndexOf + 1);
        }
        return path;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public abstract DeploymentType getDeploymentType();

    public static enum DeploymentType {
        INITIAL,
        UPGRADE,
        UNDEPLOY,
        UNKNOWN;

    }
}

