/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.PackageScanner;
import com.xebialabs.deployit.service.importer.reader.DeployableConfigurationItemReader;
import com.xebialabs.deployit.service.importer.reader.ManifestReader;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestBasedDarImporter
implements ListableImporter {
    public static final String TEMPORARY_FILES = "temporaryFiles";
    private static final Logger logger = LoggerFactory.getLogger(ManifestBasedDarImporter.class);

    public List<String> list(File directory) {
        ArrayList packages = Lists.newArrayList(PackageScanner.scan(directory));
        Collections.sort(packages);
        return packages;
    }

    public boolean canHandle(ImportSource source) {
        File file = source.getFile();
        return PackageScanner.isDarPackage(file) || PackageScanner.isExplodedPackage(file);
    }

    public PackageInfo preparePackage(ImportSource source, ImportingContext ctx) {
        PackageInfo packageInfo = new PackageInfo(source);
        this.updatePackageInfoWithManifestValues(packageInfo);
        ctx.setAttribute(TEMPORARY_FILES, (Object)Lists.newArrayList());
        return packageInfo;
    }

    private void updatePackageInfoWithManifestValues(PackageInfo packageInfo) {
        Manifest manifest = this.getManifest(packageInfo);
        ManifestReader.verifyPackageFormatVersion(manifest);
        packageInfo.setApplicationName(ManifestReader.getApplicationName(manifest));
        packageInfo.setApplicationVersion(ManifestReader.getApplicationVersion(manifest));
    }

    public ImportedPackage importEntities(PackageInfo packageInfo, ImportingContext ctx) {
        ImportedPackage importedPackage = new ImportedPackage(packageInfo);
        Manifest manifest = this.getManifest(packageInfo);
        this.createDeployableEntities(packageInfo, manifest.getEntries(), importedPackage, ctx);
        return importedPackage;
    }

    private void createDeployableEntities(PackageInfo packageInfo, Map<String, Attributes> entries, ImportedPackage importedPackage, ImportingContext ctx) {
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            if (DeployableConfigurationItemReader.isMiddlewareResource(entry)) {
                importedPackage.addDeployable(DeployableConfigurationItemReader.readMiddlewareConfiguration(importedPackage.getDeploymentPackage(), entry));
                continue;
            }
            importedPackage.addDeployable((Deployable)DeployableConfigurationItemReader.readArtifact(importedPackage.getDeploymentPackage(), packageInfo.getSource(), entry, ctx));
        }
    }

    private Manifest getManifest(PackageInfo packageInfo) {
        TFile manifestFileForUnpackedPackage = PackageScanner.getManifestFileFromImportSource(packageInfo.getSource());
        return ManifestReader.readManifest(manifestFileForUnpackedPackage);
    }

    public void cleanUp(PackageInfo packageInfo, ImportingContext ctx) {
        List files = (List)ctx.getAttribute(TEMPORARY_FILES);
        for (TFile file : files) {
            logger.debug("Cleaning up temporary file {}", (Object)file);
            try {
                if (file.isDirectory()) {
                    file.rm_r();
                    continue;
                }
                file.rm();
            }
            catch (IOException e) {
                logger.error("Couldn't clean up file {}", (Object)file, (Object)e);
            }
        }
    }
}

