/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.List;
import java.util.Map;

public class InMemoryRepositoryService
implements RepositoryService {
    private Map<String, RepositoryObjectEntity> store = Maps.newHashMap();

    @Override
    public <T extends RepositoryObjectEntity> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((RepositoryObjectEntity[])entities);
        this.storeEntities((RepositoryObjectEntity[])entities);
    }

    private void checkThatEntitiesDoNotExist(RepositoryObjectEntity[] entities) {
        for (RepositoryObjectEntity entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(RepositoryObjectEntity[] entities) {
        for (RepositoryObjectEntity entity : entities) {
            this.store.put(entity.getId(), entity);
        }
    }

    @Override
    public <T extends RepositoryObjectEntity> T read(String id) {
        return (T)this.store.get(id);
    }

    @Override
    public <T extends RepositoryObjectEntity> T readFully(String id) {
        return this.read(id);
    }

    @Override
    public <T extends RepositoryObjectEntity> void update(T ... entities) {
        for (T entity : entities) {
            if (this.store.containsKey(((RepositoryObjectEntity)entity).getId())) continue;
            throw new IllegalStateException("Cannot update nonexisting");
        }
        for (T entity : entities) {
            this.store.put(((RepositoryObjectEntity)entity).getId(), (RepositoryObjectEntity)entity);
        }
    }

    @Override
    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    @Override
    public void execute(ChangeSet batchUpdate) {
        if (!batchUpdate.getCreateEntities().isEmpty()) {
            this.create(batchUpdate.getCreateEntities().toArray(new RepositoryObjectEntity[batchUpdate.getCreateEntities().size()]));
        }
        if (!batchUpdate.getUpdateEntities().isEmpty()) {
            this.update(batchUpdate.getUpdateEntities().toArray(new RepositoryObjectEntity[batchUpdate.getUpdateEntities().size()]));
        }
        if (!batchUpdate.getDeleteEntityIds().isEmpty()) {
            this.delete(batchUpdate.getDeleteEntityIds().toArray(new String[batchUpdate.getDeleteEntityIds().size()]));
        }
    }

    @Override
    public List<String> list(SearchParameters criteria) {
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    @Override
    public <T extends RepositoryObjectEntity> List<T> listEntities(SearchParameters parameters) {
        throw new UnsupportedOperationException("Ask Robert and Vincent");
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet batchUpdate) throws ItemInUseException {
    }

    @Override
    public boolean checkNodeExists(String id) {
        return this.store.containsKey(id);
    }
}

