/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.grouping;

import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import java.lang.reflect.Field;

public class Sum
implements Function<Long> {
    private final String property;
    private final String name;
    private final Field field;

    public Sum(String name, String property) {
        this.name = name;
        this.property = property;
        this.field = this.getField(property);
    }

    private Field getField(String property) {
        Field field = null;
        try {
            field = DeploymentTaskInfo.class.getDeclaredField(property);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            new IllegalArgumentException(String.format("Property is %s not defined in %s.", property, DeploymentTaskInfo.class.getName()), e);
        }
        return field;
    }

    @Override
    public Long invoke(Object previousValue, DeploymentTaskInfo task) {
        try {
            if (previousValue != null) {
                return (Long)previousValue + this.field.getLong(task);
            }
            return this.field.getLong(task);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Property " + this.property + " is not numeric.", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

