package com.xebialabs.deployit.service.importer;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.io.DecoratingInputStream;

import java.io.FileNotFoundException;
import java.io.IOException;

public class TemporaryFileInputStream extends DecoratingInputStream {
	private final TFile _file;

	/**
	 * Constructs a new decorating input stream.
	 *
	 * @param inFile the temporary TFile archive which needs to be deleted upon #close()
	 */
	public TemporaryFileInputStream(TFile inFile) throws FileNotFoundException {
		super(new TFileInputStream(inFile));
		this._file = inFile;
	}

	@Override
	public void close() throws IOException {
		try {
			super.close();
		} finally {
			if (_file.isDirectory()) {
				_file.rm_r();
			} else {
				_file.rm();
			}
		}
	}
}
