package com.xebialabs.deployit.service.discovery;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.task.ExecutionContextAttributes;

@Component
public class DiscoveryService {

	private final PojoConverter pojoConverter;
	private final Inspector inspector;

	@Autowired
	public DiscoveryService(PojoConverter pojoConverter, Inspector inspector) {
		this.pojoConverter = pojoConverter;
		this.inspector = inspector;
	}

	public List<ConfigurationItemEntity> discoverConfigurationItem(final ConfigurationItemEntity ci) {
		PojoConverter.Context pojoConverterContext = pojoConverter.getContext();

		try {
			ConfigurationItem configurationItem = pojoConverterContext.toPojo(ci);

			ExecutionContextAttributes executionContext = new ExecutionContextAttributes();
			try {
				List<ConfigurationItem> discovered = inspector.inspect(configurationItem, executionContext.getAttributes());
				List<ConfigurationItemEntity> discoveredEntities = pojoConverterContext.toEntity(discovered);

				return discoveredEntities;
			} finally {
				executionContext.destroy();
			}
		} finally {
			pojoConverterContext.destroy();
		}
	}

}
