package com.xebialabs.deployit.security.permission;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.checks.Checks.checkArgument;

import java.util.Collection;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrRepositoryServiceHolder;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;

public class UndeploymentHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.UNDEPLOY, user, action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, newArrayList("Environments", "Infrastructure"), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
		permission(Permission.UNDEPLOY, user, onConfigurationItem, action);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
		final RepositoryObjectEntity objectEntity = JcrRepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
		privileges(REMOVE_CHILD_NODES_PRIVILEGES, user, (Collection<String>) objectEntity.getValue("members"), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	Permission getPermission() {
		return Permission.UNDEPLOY;
	}
}
