package com.xebialabs.deployit.security.permission;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

import java.util.Collection;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrRepositoryServiceHolder;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;

/**
 * Grants a user:
 * - deployment#initial permission
 * - (add|remove)_child_node rights on the Environment
 * - (add|remove)_child_node rights on the members of an Environment (ie. infrastructure)
 * - read rights on the Application
 */
public class InitialDeploymentHandler extends PermissionHandler {

	@Override
	protected void handle(String user, Action action) {
		permission(Permission.DEPLOY_INITIAL, user, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	protected void handle(String user, String onConfigurationItem, Action action) {
		checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
		permission(Permission.DEPLOY_INITIAL, user, onConfigurationItem, action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
		final RepositoryObjectEntity objectEntity = JcrRepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, (Collection<String>) objectEntity.getValue("members"), action);
		privileges(ADD_CHILD_NODES_PRIVILEGES, user, JcrConstants.TASKS_NODE_NAME, action);
	}

	@Override
	Permission getPermission() {
		return Permission.DEPLOY_INITIAL;
	}
}

