package com.xebialabs.deployit.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class JcrRepositoryServiceHolder {

	private static final AtomicReference<RepositoryService> repositoryService = new AtomicReference<RepositoryService>();

	@Autowired
	public JcrRepositoryServiceHolder(RepositoryService repositoryService) {
		JcrRepositoryServiceHolder.repositoryService.set(repositoryService);
	}

	public static RepositoryService getRepositoryService() {
		return JcrRepositoryServiceHolder.repositoryService.get();
	}
}
