/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Upgrader {
    private ApplicationContext context;
    private JcrTemplate jcrTemplate;
    private ListMultimap<String, Upgrade> upgradeBeans;

    @Autowired
    public Upgrader(ApplicationContext context, JcrTemplate jcrTemplate) {
        this.context = context;
        this.jcrTemplate = jcrTemplate;
    }

    public void doUpgrade() {
        this.upgradeBeans = this.getUpgrades();
        for (String component : this.upgradeBeans.keySet()) {
            this.upgradeComponent(component);
        }
    }

    void upgradeComponent(String component) {
        Version deployitVersion = this.readVersionOfComponent(component);
        List<Upgrade> applicableUpgrades = this.filterUpgrades(this.upgradeBeans.get((Object)component), deployitVersion);
        if (!applicableUpgrades.isEmpty()) {
            this.applyUpgrades(applicableUpgrades);
            this.storeVersionOfComponent(component, applicableUpgrades.get(applicableUpgrades.size() - 1).upgradeVersion());
        }
    }

    void storeVersionOfComponent(final String component, final Version version) {
        this.jcrTemplate.executeAsAdmin(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node node = session.getNode("/$configuration/versions");
                node.setProperty(component, version.getVersion());
                session.save();
                return null;
            }
        });
    }

    Version readVersionOfComponent(final String component) {
        return this.jcrTemplate.executeAsAdmin(new JcrCallback<Version>(){

            @Override
            public Version doInJcr(Session session) throws IOException, RepositoryException {
                Node node = session.getNode("/$configuration/versions");
                if (node.hasProperty(component)) {
                    Property versionProp = node.getProperty(component);
                    return Version.valueOf((String)component, (String)versionProp.getString());
                }
                return Version.valueOf((String)component, (String)"0.0.0");
            }
        });
    }

    private void applyUpgrades(List<Upgrade> applicableUpgrades) {
        for (Upgrade applicableUpgrade : applicableUpgrades) {
            if (applicableUpgrade.doUpgrade()) continue;
            throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{applicableUpgrade.getClass(), applicableUpgrade.upgradeVersion()});
        }
    }

    private List<Upgrade> filterUpgrades(Collection<Upgrade> upgradeBeans, final Version repoVersion) {
        ArrayList applicableUpgrades = Lists.newArrayList((Iterable)Collections2.filter(upgradeBeans, (Predicate)new Predicate<Upgrade>(){

            public boolean apply(Upgrade input) {
                return input.shouldBeApplied(repoVersion);
            }
        }));
        Collections.sort(applicableUpgrades);
        return applicableUpgrades;
    }

    protected ListMultimap<String, Upgrade> getUpgrades() {
        Set upgradeClasses = ReflectionsHolder.getSubTypesOf(Upgrade.class);
        return Multimaps.index((Iterable)Collections2.transform((Collection)upgradeClasses, (Function)new Function<Class<? extends Upgrade>, Upgrade>(){

            public Upgrade apply(Class<? extends Upgrade> input) {
                return (Upgrade)Upgrader.this.context.getAutowireCapableBeanFactory().createBean(input);
            }
        }), (Function)new Function<Upgrade, String>(){

            public String apply(Upgrade input) {
                return input.upgradeVersion().getComponent();
            }
        });
    }
}

