/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.validation;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Validator {
    private RepositoryService repositoryService;

    @Autowired
    public Validator(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Validations validate(RepositoryObjectEntity roe, RepositoryObjectEntity ... cisInContext) {
        return this.validate(roe, Lists.newArrayList((Object[])cisInContext));
    }

    public Validations validate(RepositoryObjectEntity roe, List<? extends RepositoryObjectEntity> cisInContext) {
        Validations validations = new Validations();
        ConfigurationItemEntity ci = (ConfigurationItemEntity)roe;
        Type type = ci.getType();
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (!propertyDescriptor.isRequired() || propertyDescriptor.isAsContainment()) continue;
            validations.checkRequired(ci, propertyDescriptor);
        }
        for (String key : ci.getValues().keySet()) {
            if (this.isPlaceholderField(key) || !validations.checkFieldExists(ci, descriptor, key)) continue;
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(key);
            Object value = ci.getValue(propertyDescriptor);
            validations.checkType(ci, propertyDescriptor, value, this.repositoryService, cisInContext);
        }
        if (descriptor.getPropertyDescriptor("placeholders") != null) {
            Object placeholdersObject = ci.getValue("placeholders");
            if (!validations.checkHasSource(ci)) {
                return validations;
            }
            if (placeholdersObject == null || placeholdersObject instanceof Collection && ((Collection)placeholdersObject).isEmpty()) {
                String sourceId = (String)ci.getValue("deployable");
                Object source = this.repositoryService.read(sourceId);
                Object placeholdersFromSource = ((RepositoryObjectEntity)source).getValue("placeholders");
                if (placeholdersFromSource != null && !((Collection)placeholdersFromSource).isEmpty()) {
                    validations.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Missing all placeholders from source %s (%s)", sourceId, placeholdersFromSource));
                }
            } else if (validations.checkPlaceholdersOfCorrectType(ci, descriptor, placeholdersObject)) {
                validations.checkPlaceholdersAllFilled(ci, descriptor, placeholdersObject);
                validations.checkPlaceholdersAllPresent(ci, descriptor, placeholdersObject, this.repositoryService);
            }
        }
        return validations;
    }

    private boolean isPlaceholderField(String key) {
        return key.equals("placeholders");
    }

    public static class Validations
    extends ArrayList<ValidationMessage> {
        private void checkRequired(RepositoryObjectEntity ci, PropertyDescriptor propertyDescriptor) {
            Object value = ci.getValue(propertyDescriptor);
            if (value == null || value.toString().trim().isEmpty()) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s is required", propertyDescriptor.getName()));
            }
        }

        public boolean hasMessages() {
            return !this.isEmpty();
        }

        private void checkInteger(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor) {
            if (value != null) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException nfe) {
                    this.add(new ValidationMessage(ci, propertyDescriptor, "Could not convert %s with value [%s] into an int", propertyDescriptor.getName(), value));
                }
            }
        }

        private void checkBoolean(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor) {
            if (value != null) {
                if ("true".equalsIgnoreCase(value.toString()) || "false".equalsIgnoreCase(value.toString())) {
                    return;
                }
                this.add(new ValidationMessage(ci, propertyDescriptor, "Could not convert %s with value [%s] into a boolean", propertyDescriptor.getName(), value));
            }
        }

        private void checkEnum(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor) {
            if (value != null) {
                for (String enumValue : propertyDescriptor.getEnumValues()) {
                    if (!enumValue.equals(value)) continue;
                    return;
                }
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value [%s] does not contain correct enum value", propertyDescriptor.getName(), value));
            }
        }

        private boolean checkFieldExists(RepositoryObjectEntity ci, Descriptor descriptor, String key) {
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(key);
            if (propertyDescriptor == null || !propertyDescriptor.getName().equals(key)) {
                this.add(new ValidationMessage(ci, key, "Property %s does not exist on configuration item", key));
                return false;
            }
            return true;
        }

        private void checkCi(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor, RepositoryService repositoryService, List<RepositoryObjectEntity> cisInContext) {
            if (value == null || propertyDescriptor.isAsContainment()) {
                return;
            }
            if (!this.ciExists(value.toString(), repositoryService, cisInContext)) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value [%s] does not point to an existing configuration item", propertyDescriptor.getName(), value));
            }
        }

        private boolean ciExists(String ciId, RepositoryService repositoryService, List<RepositoryObjectEntity> cisInContext) {
            return repositoryService.checkNodeExists(ciId) || this.inCisContext(ciId, cisInContext);
        }

        private boolean inCisContext(String ciId, List<RepositoryObjectEntity> cisInContext) {
            for (RepositoryObjectEntity entity : cisInContext) {
                if (!entity.getId().equals(ciId)) continue;
                return true;
            }
            return false;
        }

        private void checkSetOfStrings(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor) {
            if (value == null) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Collection)) {
                valid = false;
            } else {
                for (Object o : (Collection)value) {
                    valid = valid && o instanceof String;
                }
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value %s[%s] does not contain a set of strings", propertyDescriptor.getName(), value.getClass().getSimpleName(), value));
            }
        }

        private void checkSetOfCis(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor, RepositoryService repositoryService, List<RepositoryObjectEntity> cisInContext) {
            if (value == null || propertyDescriptor.isAsContainment()) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Collection)) {
                valid = false;
            } else {
                for (Object o : (Collection)value) {
                    valid = valid && o instanceof String && this.ciExists((String)o, repositoryService, cisInContext);
                }
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value %s[%s] does not contain a set of configuration items", propertyDescriptor.getName(), value.getClass().getSimpleName(), value));
            }
        }

        private void checkType(RepositoryObjectEntity ci, PropertyDescriptor propertyDescriptor, Object value, RepositoryService repositoryService, List<RepositoryObjectEntity> cisInContext) {
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: {
                    this.checkBoolean(ci, value, propertyDescriptor);
                    break;
                }
                case INTEGER: {
                    this.checkInteger(ci, value, propertyDescriptor);
                    break;
                }
                case STRING: {
                    break;
                }
                case ENUM: {
                    this.checkEnum(ci, value, propertyDescriptor);
                    break;
                }
                case SET_OF_STRING: {
                    this.checkSetOfStrings(ci, value, propertyDescriptor);
                    break;
                }
                case CI: {
                    this.checkCi(ci, value, propertyDescriptor, repositoryService, cisInContext);
                    break;
                }
                case SET_OF_CI: {
                    this.checkSetOfCis(ci, value, propertyDescriptor, repositoryService, cisInContext);
                    break;
                }
                case MAP_STRING_STRING: {
                    this.checkMapOfString(ci, value, propertyDescriptor, repositoryService);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should not end up here!");
                }
            }
        }

        private void checkMapOfString(RepositoryObjectEntity ci, Object value, PropertyDescriptor propertyDescriptor, RepositoryService repositoryService) {
            if (value == null || propertyDescriptor.isAsContainment()) {
                return;
            }
            boolean valid = true;
            if (!(value instanceof Map)) {
                valid = false;
            }
            if (!valid) {
                this.add(new ValidationMessage(ci, propertyDescriptor, "Property %s with value %s[%s] does not contain a Map<String, String>", propertyDescriptor.getName(), value.getClass().getSimpleName(), value));
            }
        }

        private void checkPlaceholdersAllFilled(ConfigurationItemEntity ci, Descriptor descriptor, Object placeholdersObject) {
            Map placeholders = (Map)placeholdersObject;
            for (Map.Entry entry : placeholders.entrySet()) {
                if (!Strings.nullToEmpty((String)((String)entry.getValue())).trim().isEmpty()) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Placeholder [%s] requires a value", entry.getKey()));
            }
        }

        public void checkPlaceholdersAllPresent(ConfigurationItemEntity ci, Descriptor descriptor, Object placeholdersObject, RepositoryService repositoryService) {
            Map placeholders = (Map)placeholdersObject;
            String sourceId = (String)ci.getValue("deployable");
            Object source = repositoryService.read(sourceId);
            Set placeholderSet = (Set)((RepositoryObjectEntity)source).getValue("placeholders");
            if (placeholderSet == null) {
                return;
            }
            Set placeholderKeys = placeholders.keySet();
            for (String placeholder : placeholderSet) {
                if (placeholderKeys.contains(placeholder)) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Placeholder [%s] is missing", placeholder));
            }
            for (String placeholder : placeholders.keySet()) {
                if (placeholderSet.contains(placeholder)) continue;
                this.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Extra placeholder [%s] found which is not present in the source", placeholder));
            }
        }

        private boolean checkPlaceholdersOfCorrectType(ConfigurationItemEntity ci, Descriptor descriptor, Object placeholdersObject) {
            if (!(placeholdersObject instanceof Map)) {
                this.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Placeholders in field [placeholders] are not of correct type [%s]", placeholdersObject.getClass().getName()));
                return false;
            }
            if (Maps.filterEntries((Map)((Map)placeholdersObject), (Predicate)new Predicate<Map.Entry<Object, Object>>(){

                public boolean apply(Map.Entry<Object, Object> input) {
                    return !(input.getKey() instanceof String) || !(input.getValue() instanceof String);
                }
            }).size() > 0) {
                this.add(new ValidationMessage((RepositoryObjectEntity)ci, "placeholders", "Placeholders in field [placeholders] are not of correct type.", new Object[0]));
                return false;
            }
            return true;
        }

        public boolean checkHasSource(ConfigurationItemEntity ci) {
            return ci.getValue("deployable") != null;
        }
    }
}

