/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.samskivert.mustache.Mustache;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderScanner;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class MustachePlaceholderScanner
implements PlaceholderScanner {
    Map<String, Map> keys = this.createComputingMap();

    private ConcurrentMap<String, Map> createComputingMap() {
        return new MapMaker().makeComputingMap((Function)new Function<String, Map>(){

            public Map<String, Map> apply(String input) {
                return MustachePlaceholderScanner.this.createComputingMap();
            }
        });
    }

    public Set<String> scan(String in) {
        Mustache.compiler().compile(in).execute(this.keys, (Writer)new DiscardingWriter());
        return this.flattenKeys(this.keys, null, Sets.newHashSet());
    }

    public Set<String> scan(Reader in) {
        Mustache.compiler().compile(in).execute(this.keys, (Writer)new DiscardingWriter());
        return this.flattenKeys(this.keys, null, Sets.newHashSet());
    }

    private Set<String> flattenKeys(Map<String, Map> scanned, String prefix, HashSet<String> collector) {
        for (Map.Entry<String, Map> e : scanned.entrySet()) {
            String key = Joiner.on((String)".").skipNulls().join((Object)prefix, (Object)e.getKey(), new Object[0]);
            if (e.getValue().isEmpty()) {
                collector.add(key);
                continue;
            }
            this.flattenKeys(e.getValue(), key, collector);
        }
        return collector;
    }

    public static boolean hasPlaceholders(String value) {
        return !new MustachePlaceholderScanner().scan(value).isEmpty();
    }

    static class DiscardingWriter
    extends Writer {
        DiscardingWriter() {
        }

        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

