/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.collect.Maps;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class MustachePlaceholderReplacer {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    private final Map<String, Object> values;

    public MustachePlaceholderReplacer(Map<String, ? extends Object> values) {
        this.values = new ReplacerMap((Map<? extends String, ? extends Object>)values);
    }

    public String replace(String replaceable) throws DictionaryValueException {
        try {
            return Mustache.compiler().compile(replaceable).execute(this.values);
        }
        catch (MustacheException me) {
            throw new DictionaryValueException(me, "Could not replace dictionary keys in %s", replaceable);
        }
    }

    public void replace(Reader in, Writer out) {
        Mustache.compiler().compile(in).execute(this.values, out);
    }

    private static class CompoundValueMap
    extends HashMap<String, Object> {
        private Object toStringValue;

        public void setToStringValue(Object toStringValue) {
            this.toStringValue = toStringValue;
        }

        @Override
        public String toString() {
            return this.toStringValue != null ? this.toStringValue.toString() : super.toString();
        }
    }

    private static class ReplacerMap
    extends HashMap<String, Object> {
        public ReplacerMap(Map<? extends String, ? extends Object> map) {
            super(ReplacerMap.buildCompoundMap(map));
        }

        private static Map<String, ? extends Object> buildCompoundMap(Map<? extends String, ? extends Object> map) {
            HashMap compound = Maps.newHashMap();
            for (Map.Entry<? extends String, ? extends Object> e : map.entrySet()) {
                String key = e.getKey();
                Object value = e.getValue();
                ReplacerMap.decompose(compound, key, value);
            }
            return compound;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void decompose(HashMap<String, Object> compound, String key, Object value) {
            if (key.contains(".")) {
                int dotIndex = key.indexOf(46);
                String firstPart = key.substring(0, dotIndex);
                String secondPart = key.substring(dotIndex + 1);
                if (compound.containsKey(firstPart)) {
                    Object o = compound.get(firstPart);
                    if (o instanceof CompoundValueMap) {
                        ReplacerMap.decompose((HashMap)o, secondPart, value);
                        return;
                    } else {
                        CompoundValueMap map = new CompoundValueMap();
                        map.setToStringValue(o);
                        compound.put(firstPart, map);
                        ReplacerMap.decompose(map, secondPart, value);
                    }
                    return;
                } else {
                    CompoundValueMap map = new CompoundValueMap();
                    ReplacerMap.decompose(map, secondPart, value);
                    compound.put(firstPart, map);
                }
                return;
            } else if (compound.containsKey(key)) {
                Object o = compound.get(key);
                if (!(o instanceof CompoundValueMap)) throw new RuntimeException("Cannot register same key twice");
                ((CompoundValueMap)o).setToStringValue(value);
                return;
            } else {
                compound.put(key, value);
            }
        }

        @Override
        public Object get(Object o) {
            Object s = super.get(o);
            if (MustachePlaceholderReplacer.IGNORE_PLACEHOLDER.equals(s)) {
                return "{{" + o + "}}";
            }
            if (MustachePlaceholderReplacer.EMPTY_PLACEHOLDER.equals(s)) {
                return "";
            }
            return s;
        }
    }
}

