/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.task.ExecutionContextAttributes;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryService {
    private final PojoConverter pojoConverter;
    private final Inspector inspector;

    @Autowired
    public DiscoveryService(PojoConverter pojoConverter, Inspector inspector) {
        this.pojoConverter = pojoConverter;
        this.inspector = inspector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItemEntity> discoverConfigurationItem(ConfigurationItemEntity ci) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            ConfigurationItem configurationItem = (ConfigurationItem)pojoConverterContext.toPojo(ci);
            ExecutionContextAttributes executionContext = new ExecutionContextAttributes();
            try {
                List<ConfigurationItemEntity> discoveredEntities;
                List discovered = this.inspector.inspect(configurationItem, executionContext.getAttributes());
                List<ConfigurationItemEntity> list = discoveredEntities = pojoConverterContext.toEntity(discovered);
                executionContext.destroy();
                return list;
            }
            catch (Throwable throwable) {
                executionContext.destroy();
                throw throwable;
            }
        }
        finally {
            pojoConverterContext.destroy();
        }
    }
}

