/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private PojoConverter pojoConverter;
    private DeployedGenerator deployedGenerator;

    @Autowired
    public DeployedService(PojoConverter pojoConverter, DeployedGenerator deployedGenerator) {
        this.pojoConverter = pojoConverter;
        this.deployedGenerator = deployedGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListMultimap<Boolean, ConfigurationItemEntity> generateAllDeployeds(ConfigurationItemEntity deploymentPackageEntity, ConfigurationItemEntity environmentEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            DeploymentPackage pkg = (DeploymentPackage)pojoConverterContext.toPojo(deploymentPackageEntity);
            Environment env = (Environment)pojoConverterContext.toPojo(environmentEntity);
            Set containers = env.getMembers();
            ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(env.getDictionaries());
            List<Deployed> validDeployeds = this.generateDeployedsOfType(pkg.getDeployables(), containers, null, dictionary);
            if (validDeployeds.isEmpty()) {
                throw new IllegalArgumentException("Could not generate any deployeds for " + deploymentPackageEntity.getId() + " and " + environmentEntity.getId());
            }
            ListMultimap<Boolean, ConfigurationItemEntity> listMultimap = this.createValidDeployedMap(validDeployeds, Lists.newArrayList(), pojoConverterContext);
            return listMultimap;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListMultimap<Boolean, ConfigurationItemEntity> generateSelectedDeployeds(List<ConfigurationItemEntity> deployableEntities, ConfigurationItemEntity environmentEntity) {
        final PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            Environment env = (Environment)pojoConverterContext.toPojo(environmentEntity);
            Set containers = env.getMembers();
            ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(env.getDictionaries());
            List deployables = Lists.transform(deployableEntities, (Function)new Function<ConfigurationItemEntity, Deployable>(){

                public Deployable apply(ConfigurationItemEntity from) {
                    ConfigurationItem deployable = (ConfigurationItem)pojoConverterContext.toPojo(from);
                    Checks.checkArgument(deployable instanceof Deployable, "The entity %s is not a deployable", from.getId());
                    return (Deployable)deployable;
                }
            });
            ListMultimap<Boolean, ConfigurationItemEntity> listMultimap = this.createValidDeployedMap(this.generateDeployedsOfType(deployables, containers, null, dictionary), Lists.newArrayList(), pojoConverterContext);
            return listMultimap;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListMultimap<Boolean, ConfigurationItemEntity> generateSelectedDeployed(ConfigurationItemEntity deployableEntity, ConfigurationItemEntity containerEntity, String deployedTypeString, ConfigurationItemEntity environmentEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            Type deployedType = null;
            if (deployedTypeString != null && !deployedTypeString.trim().isEmpty()) {
                deployedType = Type.valueOf((String)deployedTypeString);
            }
            Deployable deployable = (Deployable)pojoConverterContext.toPojo(deployableEntity);
            Container container = (Container)pojoConverterContext.toPojo(containerEntity);
            Environment environment = (Environment)pojoConverterContext.toPojo(environmentEntity);
            ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(environment.getDictionaries());
            ListMultimap<Boolean, ConfigurationItemEntity> listMultimap = this.createValidDeployedMap(this.generateDeployedsOfType(Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), deployedType, dictionary), Lists.newArrayList(), pojoConverterContext);
            return listMultimap;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListMultimap<Boolean, ConfigurationItemEntity> generateUpgradedDeployeds(ConfigurationItemEntity newSourceEntity, ConfigurationItemEntity deploymentEntity) {
        PojoConverter.Context pojoConverterContext = this.pojoConverter.getContext();
        try {
            DeployedApplication deployment = (DeployedApplication)pojoConverterContext.toPojo(deploymentEntity);
            Environment environment = deployment.getEnvironment();
            ConsolidatedDictionary dictionary = ConsolidatedDictionary.create(environment.getDictionaries());
            DeploymentPackage newPackage = (DeploymentPackage)pojoConverterContext.toPojo(newSourceEntity);
            ArrayList upgradeDeployeds = Lists.newArrayList();
            ArrayList oldDeployeds = Lists.newArrayList();
            for (final Deployed deployed : deployment.getDeployeds()) {
                Collection filtered = Collections2.filter((Collection)newPackage.getDeployables(), (Predicate)new Predicate<Deployable>(){

                    public boolean apply(Deployable input) {
                        return DeployedService.this.isSimilar(input, deployed.getDeployable());
                    }
                });
                if (filtered.size() == 0) {
                    oldDeployeds.add(this.deployedGenerator.generateUpgradeDeployed(deployed.getDeployable(), deployed, dictionary));
                    continue;
                }
                if (filtered.size() == 1) {
                    upgradeDeployeds.add(this.deployedGenerator.generateUpgradeDeployed((Deployable)filtered.iterator().next(), deployed, dictionary));
                    continue;
                }
                throw new IllegalArgumentException(String.format("More than 1 applicable deployable found in new package for %s, will not fly.", deployed));
            }
            ListMultimap<Boolean, ConfigurationItemEntity> listMultimap = this.createValidDeployedMap(upgradeDeployeds, oldDeployeds, pojoConverterContext);
            return listMultimap;
        }
        finally {
            pojoConverterContext.destroy();
        }
    }

    private ListMultimap<Boolean, ConfigurationItemEntity> createValidDeployedMap(List<Deployed> validDeployeds, List<Deployed> invalidDeployeds, PojoConverter.Context pojoConverterContext) {
        ArrayListMultimap deployedsMap = ArrayListMultimap.create();
        deployedsMap.putAll((Object)Boolean.TRUE, this.convertDeployeds(validDeployeds, pojoConverterContext));
        deployedsMap.putAll((Object)Boolean.FALSE, this.convertDeployeds(invalidDeployeds, pojoConverterContext));
        return deployedsMap;
    }

    private boolean isSimilar(Deployable newDeployable, Deployable deployable) {
        return newDeployable.getType().equals((Object)deployable.getType()) && newDeployable.getName().equals(deployable.getName());
    }

    private List<Deployed> generateDeployedsOfType(Collection<Deployable> deployables, Collection<Container> containers, Type deployedType, ConsolidatedDictionary dictionary) {
        ArrayList deployeds = Lists.newArrayList();
        for (Deployable deployable : deployables) {
            for (Container container : containers) {
                if (deployedType != null) {
                    if (!this.deployedGenerator.findDeployedTypesForDeployableAndContainerTypes(deployable.getType(), container.getType()).contains(deployedType)) continue;
                    deployeds.add(this.deployedGenerator.generateDeployed(deployable, container, deployedType, dictionary));
                    continue;
                }
                Deployed deployed = this.deployedGenerator.generateMostSpecificDeployed(deployable, container, dictionary);
                if (deployed == null) continue;
                deployeds.add(deployed);
            }
        }
        return deployeds;
    }

    private List<ConfigurationItemEntity> convertDeployeds(List<Deployed> deployeds, final PojoConverter.Context pojoConverterContext) {
        return Lists.newArrayList((Iterable)Lists.transform(deployeds, (Function)new Function<Deployed, ConfigurationItemEntity>(){

            public ConfigurationItemEntity apply(Deployed from) {
                return pojoConverterContext.toEntity(from);
            }
        }));
    }
}

