/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DeployedGenerator.class);

    public Deployed generateMostSpecificDeployed(Deployable d, Container c, ConsolidatedDictionary dictionary) {
        Type deployedType = this.findMostSpecificDeployedTypeForDeployableAndContainerTypes(d.getType(), c.getType());
        if (deployedType != null) {
            return this.generateDeployed(d, c, deployedType, dictionary);
        }
        return null;
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType, ConsolidatedDictionary dictionary) {
        Descriptor deployed = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed configurationItem = (Deployed)deployed.newInstance();
        configurationItem.setDeployable(d);
        configurationItem.setContainer(c);
        IdGenerator.generateId((Deployed)configurationItem);
        Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)d.getType());
        for (PropertyDescriptor propertyDescriptor : deployed.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            if (!propertyDescriptor.getName().equals("placeholders")) {
                PropertyDescriptor deployablePropertyDescriptor = deployableDescriptor.getPropertyDescriptor(name);
                if (deployablePropertyDescriptor == null) continue;
                Object valueFromDeployable = deployablePropertyDescriptor.get((ConfigurationItem)d);
                this.setDeployedValue(valueFromDeployable, (Deployed<Deployable, Container>)configurationItem, propertyDescriptor, dictionary);
                continue;
            }
            PropertyDescriptor deployableplaceholders = deployableDescriptor.getPropertyDescriptor("placeholders");
            Set placeholders = (Set)deployableplaceholders.get((ConfigurationItem)d);
            propertyDescriptor.set((ConfigurationItem)configurationItem, this.resolveAllPlaceholders(dictionary, Maps.newHashMap(), placeholders));
        }
        return configurationItem;
    }

    private void setDeployedValue(Object value, Deployed<Deployable, Container> deployed, PropertyDescriptor property, ConsolidatedDictionary dictionary) {
        try {
            value = dictionary.resolve(value);
            property.set(deployed, value);
        }
        catch (DictionaryValueException dve) {
            logger.error("Could not resolve dictionary keys", (Throwable)dve);
        }
        catch (RuntimeException e) {
            logger.error("Could not convert (resolved) value to correct type", (Throwable)e);
        }
    }

    public Deployed generateUpgradeDeployed(Deployable newDeployable, Deployed deployed, ConsolidatedDictionary dictionary) {
        Type newDeployableType;
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Type deployableType = deployedDesc.getDeployableType();
        Checks.checkArgument(deployableType.equals((Object)(newDeployableType = newDeployable.getType())) || DescriptorRegistry.getSubtypes((Type)deployableType).contains(newDeployableType), "The new Deployable type %s should be assignable to %s", newDeployableType, deployableType);
        Deployed newDeployed = (Deployed)deployedDesc.newInstance();
        Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)deployableType);
        for (PropertyDescriptor propertyDescriptor : deployedDesc.getPropertyDescriptors()) {
            Object oldDeployedValue;
            String name = propertyDescriptor.getName();
            if (name.equals("placeholders")) continue;
            Object valueToSet = oldDeployedValue = propertyDescriptor.get((ConfigurationItem)deployed);
            PropertyDescriptor deployablePropertyDescriptor = deployableDescriptor.getPropertyDescriptor(name);
            if (deployablePropertyDescriptor != null) {
                Object oldDeployableValue = deployablePropertyDescriptor.get((ConfigurationItem)deployed.getDeployable());
                if (oldDeployableValue != null && (oldDeployableValue.equals(oldDeployedValue) || MustachePlaceholderScanner.hasPlaceholders(oldDeployableValue.toString()))) {
                    valueToSet = deployablePropertyDescriptor.get((ConfigurationItem)newDeployable);
                }
                try {
                    valueToSet = dictionary.resolve(valueToSet);
                }
                catch (DictionaryValueException dve) {
                    valueToSet = null;
                    logger.error("Could not resolve dictionary keys", (Throwable)dve);
                }
            }
            try {
                propertyDescriptor.set((ConfigurationItem)newDeployed, valueToSet);
            }
            catch (RuntimeException re) {
                logger.error("Could not convert (resolved) value to correct type", (Throwable)re);
            }
        }
        this.copyOverPlaceholdersToDeployed((Deployed<Deployable, Container>)newDeployed, newDeployable, deployed, dictionary);
        newDeployed.setDeployable(newDeployable);
        newDeployed.setId(deployed.getId());
        return newDeployed;
    }

    private void copyOverPlaceholdersToDeployed(Deployed<Deployable, Container> newDeployed, Deployable newDeployable, Deployed deployed, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)newDeployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)newDeployable.getType());
        PropertyDescriptor deployedPlaceholdersDesc = deployedDesc.getPropertyDescriptor("placeholders");
        if (deployedPlaceholdersDesc != null) {
            Map existingDeployedPlaceholders = (Map)deployedPlaceholdersDesc.get((ConfigurationItem)deployed);
            Set newDeployablePlaceholders = (Set)deployableDesc.getPropertyDescriptor("placeholders").get((ConfigurationItem)newDeployable);
            deployedPlaceholdersDesc.set(newDeployed, this.resolveAllPlaceholders(dictionary, existingDeployedPlaceholders, newDeployablePlaceholders));
        }
    }

    private Map<String, String> resolveAllPlaceholders(ConsolidatedDictionary dictionary, Map<String, String> existingDeployedPlaceholders, Set<String> newDeployablePlaceholders) {
        HashMap newDeployedPlaceholders = Maps.newHashMap();
        for (String newDeployablePlaceholder : newDeployablePlaceholders) {
            if (existingDeployedPlaceholders.containsKey(newDeployablePlaceholder)) {
                newDeployedPlaceholders.put(newDeployablePlaceholder, existingDeployedPlaceholders.get(newDeployablePlaceholder));
                continue;
            }
            String resolved = "";
            try {
                resolved = (String)dictionary.resolve("{{" + newDeployablePlaceholder + "}}");
            }
            catch (DictionaryValueException e) {
                // empty catch block
            }
            newDeployedPlaceholders.put(newDeployablePlaceholder, resolved);
        }
        return newDeployedPlaceholders;
    }

    public Type findMostSpecificDeployedTypeForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        List<Type> deployedTypesForDeployableAndContainer = this.findDeployedTypesForDeployableAndContainerTypes(deployableType, containerType);
        if (deployedTypesForDeployableAndContainer.isEmpty()) {
            return null;
        }
        if (deployedTypesForDeployableAndContainer.size() == 1) {
            return deployedTypesForDeployableAndContainer.get(0);
        }
        List<Type> copy = this.filterMostSpecific(deployedTypesForDeployableAndContainer);
        if (copy.size() == 1) {
            return copy.get(0);
        }
        throw new IllegalArgumentException(String.format("Found %s for %s and %s, expected only 1", copy, deployableType, containerType));
    }

    List<Type> filterMostSpecific(List<Type> deployedTypesForDeployableAndContainer) {
        ArrayList copy = Lists.newArrayList(deployedTypesForDeployableAndContainer);
        for (Type currentType : deployedTypesForDeployableAndContainer) {
            Descriptor currentDescriptor = DescriptorRegistry.getDescriptor((Type)currentType);
            Iterator copyIt = copy.iterator();
            while (copyIt.hasNext()) {
                Type comparedType = (Type)copyIt.next();
                Descriptor comparedDescriptor = DescriptorRegistry.getDescriptor((Type)comparedType);
                boolean deployableEquals = comparedDescriptor.getDeployableType().equals((Object)currentDescriptor.getDeployableType());
                boolean containerEquals = comparedDescriptor.getContainerType().equals((Object)currentDescriptor.getContainerType());
                boolean containerSupertype = this.isSubType(comparedDescriptor.getContainerType(), currentDescriptor.getContainerType());
                boolean deployableSupertype = this.isSubType(comparedDescriptor.getDeployableType(), currentDescriptor.getDeployableType());
                boolean isSupertype = this.isSubType(comparedType, currentType);
                if (!(containerSupertype && deployableEquals || deployableSupertype && containerEquals || deployableSupertype && containerSupertype) && !isSupertype) continue;
                copyIt.remove();
            }
        }
        return copy;
    }

    private boolean isSubType(Type superType, Type subType) {
        return DescriptorRegistry.getSubtypes((Type)superType).contains(subType);
    }

    public List<Type> findDeployedTypesForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        Collection deployedTypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Deployed.class));
        final Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)deployableType);
        final Descriptor containerDescriptor = DescriptorRegistry.getDescriptor((Type)containerType);
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)deployedTypes, (Predicate)new Predicate<Type>(){

            public boolean apply(Type input) {
                Descriptor deployedDescriptor = DescriptorRegistry.getDescriptor((Type)input);
                return !deployedDescriptor.isVirtual() && deployableDescriptor.isAssignableTo(deployedDescriptor.getDeployableType()) && containerDescriptor.isAssignableTo(deployedDescriptor.getContainerType());
            }
        }));
    }
}

