/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionHelper {
    private static final Logger logger = LoggerFactory.getLogger(PermissionHelper.class);

    static void grantPermission(Permission permission, String user, String onConfigurationItem) {
        PermissionHelper.grantPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), user);
    }

    static void grantPermission(Permission permission, String user) {
        PermissionHelper.grantPermission(permission.getPermissionName(), user);
    }

    private static void grantPermission(String permission, String user) {
        SecurityServiceLocator.getPermissionService().grantPermission(permission, user);
    }

    static void revokePermission(Permission permission, String user, String onConfigurationItem) {
        PermissionHelper.revokePermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), user);
    }

    static void revokePermission(Permission permission, String user) {
        PermissionHelper.revokePermission(permission.getPermissionName(), user);
    }

    private static void revokePermission(String permission, String user) {
        SecurityServiceLocator.getPermissionService().denyPermission(permission, user);
    }

    static boolean hasPermission(Permission permission) {
        return PermissionHelper.hasPermission(permission.getPermissionName());
    }

    private static boolean hasPermission(String permission) {
        return SecurityServiceLocator.getPermissionService().hasLoggedInUserPermission(permission);
    }

    static boolean hasPermission(Permission permission, List<String> onConfigurationItems) {
        boolean allowed = !onConfigurationItems.isEmpty();
        for (String onConfigurationItem : onConfigurationItems) {
            List<String> fullTree = PermissionHelper.getFullTreeAsSeparateNodes(onConfigurationItem);
            boolean hasPermissionOnTreePart = false;
            for (String s : fullTree) {
                hasPermissionOnTreePart = hasPermissionOnTreePart || PermissionHelper.hasPermission(permission, s);
            }
            allowed = allowed && hasPermissionOnTreePart;
        }
        return allowed || PermissionHelper.hasPermission(permission);
    }

    private static List<String> getFullTreeAsSeparateNodes(String onConfigurationItem) {
        ArrayList list = Lists.newArrayList();
        list.add(onConfigurationItem);
        int index = onConfigurationItem.indexOf(47);
        while (index > -1) {
            list.add(onConfigurationItem.substring(0, index));
            index = onConfigurationItem.indexOf(47, index + 1);
        }
        logger.debug("Split off tree: {} to {}", (Object)onConfigurationItem, (Object)list);
        return list;
    }

    private static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return PermissionHelper.hasPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem));
    }

    static boolean hasPermission(Permission permission, String principal, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionService().hasUserPermission(PermissionHelper.constructPermissionName(permission, onConfigurationItem), principal);
    }

    private static String constructPermissionName(Permission permission, String onConfigurationItem) {
        StringBuilder builder = new StringBuilder(permission.getPermissionName());
        if (onConfigurationItem != null) {
            logger.debug("constructing permission: {} with {} ", (Object)builder.toString(), (Object)onConfigurationItem);
            builder.append("_").append(onConfigurationItem.replaceAll("/", "\\$"));
        }
        return builder.toString();
    }
}

