/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrRepositoryServiceHolder;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import java.util.Collection;
import java.util.List;

public class InitialDeploymentHandler
extends PermissionHandler {
    @Override
    protected void handle(String user, PermissionHandler.Action action) {
        this.permission(Permission.DEPLOY_INITIAL, user, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Environments", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "Infrastructure", action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    protected void handle(String user, String onConfigurationItem, PermissionHandler.Action action) {
        Checks.checkArgument(onConfigurationItem.startsWith(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), "%s is not an Environment", onConfigurationItem);
        this.permission(Permission.DEPLOY_INITIAL, user, onConfigurationItem, action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, onConfigurationItem, action);
        Object objectEntity = JcrRepositoryServiceHolder.getRepositoryService().read(onConfigurationItem);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, (Collection)((RepositoryObjectEntity)objectEntity).getValue("members"), action);
        this.privileges((List<String>)ADD_CHILD_NODES_PRIVILEGES, user, "tasks", action);
    }

    @Override
    Permission getPermission() {
        return Permission.DEPLOY_INITIAL;
    }
}

